/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.comparison;

import edu.msu.cme.rdp.classifier.comparison.Ztable;

public class SigCalculator {
    private static final int FREQ_LIMIT = 5;
    private int s1Total;
    private int s2Total;
    private int combinedTotal;
    private double faction;
    private double ratio_1;
    private double ratio_2;
    private float confidence;
    private Ztable ztable;

    public SigCalculator(int total1, int total2, float conf) {
        if (this.ztable == null) {
            this.ztable = new Ztable();
        }
        this.s1Total = total1;
        this.s2Total = total2;
        this.combinedTotal = this.s1Total + this.s2Total;
        this.faction = 1.0 / (double)this.s1Total + 1.0 / (double)this.s2Total;
        this.confidence = conf;
        this.ratio_1 = (double)total1 / (double)total2;
        this.ratio_2 = (double)total2 / (double)total1;
    }

    public int getS1Total() {
        return this.s1Total;
    }

    public int getS2Total() {
        return this.s2Total;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public double calculateSig(int s1, int s2) {
        if (s1 <= 5 || s2 <= 5 || this.s1Total - s1 <= 5 || this.s2Total - s2 <= 5) {
            return this.smallProportionTest(s1, s2);
        }
        return this.largeProportionTest(s1, s2);
    }

    double smallProportionTest(int s1, int s2) {
        double ratio = 0.0;
        int upperLimit = 0;
        int constantValue = 0;
        double percent_s1 = (double)s1 / (double)this.s1Total;
        double percent_s2 = (double)s2 / (double)this.s2Total;
        if (percent_s1 >= percent_s2) {
            constantValue = s1;
            upperLimit = s2;
            ratio = this.ratio_2;
        } else {
            constantValue = s2;
            upperLimit = s1;
            ratio = this.ratio_1;
        }
        double log_ratio = Math.log(ratio);
        double log_ratio_add1 = Math.log(ratio + 1.0);
        double sum_prob = 0.0;
        int i = 0;
        double prev_factorial = 0.0;
        double p2 = (double)i * log_ratio - (double)(constantValue + i + 1) * log_ratio_add1;
        sum_prob += Math.exp(prev_factorial + p2);
        for (i = 1; i <= upperLimit; ++i) {
            p2 = (double)i * log_ratio - (double)(constantValue + i + 1) * log_ratio_add1;
            sum_prob += Math.exp((prev_factorial += Math.log(constantValue + i) - Math.log(i)) + p2);
        }
        return sum_prob * 2.0;
    }

    double calFactorial(int x, int y) {
        double result = 0.0;
        int total = x + y;
        int min = Math.min(x, y);
        for (int i = 0; i < min; ++i) {
            result += Math.log((double)(total - i) / (double)(min - i));
        }
        return result;
    }

    double largeProportionTest(int s1, int s2) {
        double p1 = (double)s1 / (double)this.s1Total;
        double p2 = (double)s2 / (double)this.s2Total;
        double p = (double)(s1 + s2) / (double)this.combinedTotal;
        if (p == 0.0 || p == 1.0) {
            return 1.0;
        }
        double z = (p1 - p2) / Math.sqrt(p * (1.0 - p) * this.faction);
        return this.ztable.getPvalue(z);
    }
}

