## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)
library(knitr)
library(kableExtra)

## ----install, eval=FALSE------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# 
# BiocManager::install("HiCaptuRe")

## ----install2, eval=FALSE-----------------------------------------------------
# BiocManager::install("LaureTomas/HiCaptuRe")

## ----summary,echo=FALSE-------------------------------------------------------
# Define the table with emojis in logical columns
format_table <- data.frame(
    Format = c("`ibed`", "`peakmatrix`", "`seqMonk`", "`bedpe`", "`washU`", "`washUold`"),
    `Recommended Use` = c(
        "Standard HiCaptuRe input",
        "High-throughput liCHi-C",
        "Visualization in SeqMonk",
        "Generic interaction input/output",
        "WashU browser upload",
        "Legacy WashU format"
    ),
    `Bait/OE Annotation` = c("✅", "✅", "✅ (split rows)", "❌", "❌", "❌"),
    `CHiCAGO Score` = c("✅", "✅", "✅", "✅", "✅ (embedded)", "✅"),
    `Multi-sample` = c("❌", "✅", "❌", "❌", "❌", "❌"),
    check.names = FALSE
)

# Render the table
kable(format_table,
    format = "html", escape = FALSE,
    caption = "Summary of Supported Data Formats in HiCaptuRe"
) |>
    kable_styling(
        bootstrap_options = c("striped", "hover", "condensed", "responsive"),
        full_width = FALSE, position = "center"
    ) |>
    row_spec(0, extra_css = "text-align: center;")

## ----example------------------------------------------------------------------
ibed1_file <- system.file("extdata", "ibed1_example.zip", package = "HiCaptuRe")
ibed2_file <- system.file("extdata", "ibed2_example.zip", package = "HiCaptuRe")
peakmatrix_file <- system.file("extdata", "peakmatrix_example.zip", package = "HiCaptuRe")
annotation_file <- system.file("extdata", "annotation_example.txt", package = "HiCaptuRe")

## ----sessioninfo--------------------------------------------------------------
sessionInfo()

