/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeListener;

class HashedAlphabetIndex
extends AbstractChangeable
implements AlphabetIndex {
    private static final Comparator cmp = new HashComparator();
    private final FiniteAlphabet alpha;
    private final Symbol[] symbols;
    private final int[] hashes;

    public HashedAlphabetIndex(FiniteAlphabet finiteAlphabet) {
        finiteAlphabet.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
        this.alpha = finiteAlphabet;
        this.symbols = new Symbol[finiteAlphabet.size()];
        this.hashes = new int[finiteAlphabet.size()];
        int n = 0;
        Iterator iterator = finiteAlphabet.iterator();
        while (iterator.hasNext()) {
            this.symbols[n++] = (Symbol)iterator.next();
        }
        Arrays.sort(this.symbols, cmp);
        n = 0;
        while (n < this.symbols.length) {
            this.hashes[n] = this.symbols[n].hashCode();
            ++n;
        }
    }

    public FiniteAlphabet getAlphabet() {
        return this.alpha;
    }

    public int indexForSymbol(Symbol symbol) throws IllegalSymbolException {
        int n = Arrays.binarySearch(this.hashes, symbol.hashCode());
        if (n < 0) {
            this.getAlphabet().validate(symbol);
            if (symbol instanceof AtomicSymbol) {
                throw new BioError("Assertion Failure: Symbol " + symbol.getName() + " was not an indexed member of the alphabet " + this.getAlphabet().getName() + " despite being in the alphabet.");
            }
            throw new IllegalSymbolException("Symbol must be atomic to be indexed.");
        }
        return n;
    }

    public Symbol symbolForIndex(int n) throws IndexOutOfBoundsException {
        return this.symbols[n];
    }

    private static class HashComparator
    implements Comparator {
        HashComparator() {
        }

        public int compare(Object object, Object object2) {
            return object.hashCode() - object2.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof HashComparator;
        }
    }
}

