/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.dist.AbstractDistribution;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IgnoreCountsTrainer;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractOrderNDistribution
extends AbstractDistribution
implements OrderNDistribution,
Serializable {
    private Alphabet alphabet;
    private Alphabet firstA;
    private Alphabet lastA;
    private Distribution nullModel;
    protected transient WeigthForwarder weightForwarder = null;

    protected AbstractOrderNDistribution(Alphabet alphabet) throws IllegalAlphabetException {
        this.alphabet = alphabet;
        List list = alphabet.getAlphabets();
        int n = list.size() - 1;
        this.firstA = list.size() == 2 ? (Alphabet)list.get(0) : AlphabetManager.getCrossProductAlphabet(list.subList(0, n));
        this.lastA = (Alphabet)list.get(n);
        this.nullModel = new UniformNullModel();
    }

    public abstract Collection conditionedDistributions();

    protected void generateChangeSupport(ChangeType changeType) {
        super.generateChangeSupport(changeType);
        if ((changeType == null || changeType == Distribution.WEIGHTS) && this.weightForwarder == null) {
            this.weightForwarder = new WeigthForwarder(this, this.changeSupport);
            Iterator iterator = this.conditionedDistributions().iterator();
            while (iterator.hasNext()) {
                Distribution distribution = (Distribution)iterator.next();
                distribution.addChangeListener(this.weightForwarder, Distribution.WEIGHTS);
            }
        }
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public Alphabet getConditionedAlphabet() {
        return this.lastA;
    }

    public Alphabet getConditioningAlphabet() {
        return this.firstA;
    }

    public abstract Distribution getDistribution(Symbol var1) throws IllegalSymbolException;

    public Distribution getNullModel() {
        return this.nullModel;
    }

    protected double getWeightImpl(AtomicSymbol atomicSymbol) throws IllegalSymbolException {
        List list = atomicSymbol.getSymbols();
        int n = list.size() - 1;
        AtomicSymbol atomicSymbol2 = list.size() == 2 ? (AtomicSymbol)list.get(0) : (AtomicSymbol)this.firstA.getSymbol(list.subList(0, n));
        Distribution distribution = this.getDistribution(atomicSymbol2);
        return distribution.getWeight((AtomicSymbol)list.get(n));
    }

    public void registerWithTrainer(DistributionTrainerContext distributionTrainerContext) {
        Iterator iterator = this.conditionedDistributions().iterator();
        while (iterator.hasNext()) {
            distributionTrainerContext.registerDistribution((Distribution)iterator.next());
        }
        distributionTrainerContext.registerTrainer(this, new IgnoreCountsTrainer(){

            public void addCount(DistributionTrainerContext distributionTrainerContext, AtomicSymbol atomicSymbol, double d) throws IllegalSymbolException {
                List list = atomicSymbol.getSymbols();
                int n = list.size() - 1;
                Symbol symbol = n == 1 ? (Symbol)list.get(0) : AbstractOrderNDistribution.this.firstA.getSymbol(list.subList(0, n));
                Distribution distribution = AbstractOrderNDistribution.this.getDistribution(symbol);
                distributionTrainerContext.addCount(distribution, (Symbol)list.get(n), d);
            }
        });
    }

    public abstract void setDistribution(Symbol var1, Distribution var2) throws IllegalSymbolException, IllegalAlphabetException;

    public void setNullModelImpl(Distribution distribution) {
        this.nullModel = distribution;
    }

    public void setWeightImpl(AtomicSymbol atomicSymbol, double d) throws IllegalSymbolException, ChangeVetoException {
        List list = atomicSymbol.getSymbols();
        int n = list.size() - 1;
        Symbol symbol = list.size() == 2 ? (Symbol)list.get(0) : this.firstA.getSymbol(list.subList(0, n));
        Distribution distribution = this.getDistribution(symbol);
        distribution.setWeight((Symbol)list.get(n), d);
    }

    private class UniformNullModel
    extends AbstractDistribution
    implements Serializable {
        private Distribution nullModel;

        UniformNullModel() {
            this.nullModel = new UniformDistribution((FiniteAlphabet)AbstractOrderNDistribution.this.lastA);
        }

        public Alphabet getAlphabet() {
            return AbstractOrderNDistribution.this.getAlphabet();
        }

        public Distribution getNullModel() {
            return this;
        }

        protected double getWeightImpl(AtomicSymbol atomicSymbol) throws IllegalSymbolException {
            List list = atomicSymbol.getSymbols();
            int n = list.size() - 1;
            return this.nullModel.getWeight((AtomicSymbol)list.get(n));
        }

        protected void setNullModelImpl(Distribution distribution) throws IllegalAlphabetException, ChangeVetoException {
            throw new ChangeVetoException("Can't set the null model for NthOrderDistribution.UniformNullModel");
        }

        protected void setWeightImpl(AtomicSymbol atomicSymbol, double d) throws ChangeVetoException {
            throw new ChangeVetoException("Can't change the weight of this null model");
        }
    }

    private class WeigthForwarder
    extends ChangeForwarder {
        public WeigthForwarder(Object object, ChangeSupport changeSupport) {
            super(object, changeSupport);
        }

        protected ChangeEvent generateEvent(ChangeEvent changeEvent) {
            if (changeEvent.getType() == Distribution.WEIGHTS) {
                return new ChangeEvent(this.getSource(), Distribution.WEIGHTS, changeEvent);
            }
            return null;
        }
    }
}

