## ----echo=FALSE, results="hide", message=FALSE--------------------------------
knitr::opts_chunk$set(error = FALSE, message = FALSE, warning = FALSE)
library(BiocStyle)

## ----eval = FALSE-------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# if (!requireNamespace("slinghot", quietly = TRUE)) {
#     BiocManager::install("slingshot")
# }

## ----message=FALSE, warning=FALSE---------------------------------------------
library(dandelionR)
library(scRepertoire)
library(scater)

data(sce_vdj)

## -----------------------------------------------------------------------------
set.seed(123)

## -----------------------------------------------------------------------------
sce_vdj <- setupVdjPseudobulk(sce_vdj,
    already.productive = FALSE,
    allowed_chain_status = c(
        "Single pair", "Extra pair",
        "Extra pair-exception", "Orphan VDJ",
        "Orphan VDJ-exception"
    )
)

plotUMAP(sce_vdj, color_by = "anno_lvl_2_final_clean")

## ----warning = FALSE----------------------------------------------------------
library(miloR)
milo_object <- Milo(sce_vdj)
milo_object <- buildGraph(milo_object, k = 30, d = 20, reduced.dim = "X_scvi")
milo_object <- makeNhoods(milo_object,
    reduced_dims = "X_scvi", d = 20,
    prop = 0.3
)

## ----warning = FALSE----------------------------------------------------------
milo_object <- miloUmap(milo_object, n_neighbors = 30)

## -----------------------------------------------------------------------------
plotUMAP(milo_object,
    color_by = "anno_lvl_2_final_clean",
    dimred = "UMAP_knngraph"
)

## -----------------------------------------------------------------------------
pb.milo <- vdjPseudobulk(milo_object,
    mode_option = "abT",
    col_to_take = "anno_lvl_2_final_clean"
)

## -----------------------------------------------------------------------------
pb.milo

## -----------------------------------------------------------------------------
pb.milo <- runPCA(pb.milo, assay.type = "Feature_space", ncomponents = 20)
plotPCA(pb.milo, color_by = "anno_lvl_2_final_clean")

## -----------------------------------------------------------------------------
library(slingshot)

## -----------------------------------------------------------------------------
table(colData(pb.milo)[["anno_lvl_2_final_clean"]])

## -----------------------------------------------------------------------------
pb.milo <- slingshot(pb.milo, clusterLabels = colData(pb.milo)[["anno_lvl_2_final_clean"]], reducedDim = "PCA", start.clus = "faDP(P)_T", end.clus = c("faCD4+T", "faCD8+T"))

## -----------------------------------------------------------------------------
library(fields)
# make a color palette from blue to red
colors <- colorRampPalette(rev(c("#d7191c", "#fdae61", "#ffffbf", "#abd9e9", "#2c7bb6")))(50)
plot(reducedDims(pb.milo)$PCA, col = colors[cut(pb.milo$slingPseudotime_1, breaks = 50)], pch = 16, asp = 1)
lines(SlingshotDataSet(pb.milo), lwd = 2, col = "black")
image.plot(
    legend.only = TRUE,
    zlim = range(pb.milo$slingPseudotime_1, na.rm = TRUE),
    col = colors,
    legend.lab = "Pseudotime"
)

## -----------------------------------------------------------------------------
plot(reducedDims(pb.milo)$PCA, col = colors[cut(pb.milo$slingPseudotime_2, breaks = 50)], pch = 16, asp = 1)
lines(SlingshotDataSet(pb.milo), lwd = 2, col = "black")
image.plot(
    legend.only = TRUE,
    zlim = range(pb.milo$slingPseudotime_2, na.rm = TRUE),
    col = colors,
    legend.lab = "Pseudotime"
)

## -----------------------------------------------------------------------------
cdata <- projectPseudotimeToCell(milo_object, pb.milo, value_key = c("slingPseudotime_1", "slingPseudotime_2"))

## ----message=FALSE------------------------------------------------------------
pal <- colorRampPalette(rev((RColorBrewer::brewer.pal(9, "RdYlBu"))))(255)
plotUMAP(cdata, color_by = "anno_lvl_2_final_clean", dimred = "UMAP_knngraph")
plotUMAP(cdata, color_by = "slingPseudotime_1", dimred = "UMAP_knngraph") +
    scale_color_gradientn(colors = pal)
plotUMAP(cdata, color_by = "slingPseudotime_2", dimred = "UMAP_knngraph") +
    scale_color_gradientn(colors = pal)

## ----warning = FALSE----------------------------------------------------------
sessionInfo()

