## ----setup, include = FALSE-------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL 
## Related to https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html
)

## ----vignetteSetup, echo=FALSE, message=FALSE, warning = FALSE--------------------------------------------------------
## Bib setup
library("RefManageR")

## Write bibliography information
bib <- c(
    R = citation(),
    BiocStyle = citation("BiocStyle")[1],
    knitr = citation("knitr")[1],
    RefManageR = citation("RefManageR")[1],
    rmarkdown = citation("rmarkdown")[1],
    sessioninfo = citation("sessioninfo")[1],
    testthat = citation("testthat")[1],
    CalibraCurve = citation("CalibraCurve")[1]
)

## ----"start", message=FALSE-------------------------------------------------------------------------------------------
library("CalibraCurve")

file <- system.file("extdata", "MSQC1", "msqc1_dil_GGPFSDSYR.rds", 
                    package = "CalibraCurve")

D <- readDataSE(file, concColName = "amount_fmol", substColName = "Substance")

RES <- CalibraCurve(D)


## ----"multiplot", message=FALSE---------------------------------------------------------------------------------------
RES <- CalibraCurve(D, plot_type = "multiplot")
RES$plot_CC_list


## ----"multiplot_nrow_ncol", message=FALSE, out.width="100%"-----------------------------------------------------------
RES <- CalibraCurve(D, plot_type = "multiplot", multiplot_nrow = 3, 
                    multiplot_ncol = 4)
RES$plot_CC_list


## ----"multiplot_fixed", message=FALSE, out.width="100%"---------------------------------------------------------------
RES <- CalibraCurve(D, plot_type = "multiplot", multiplot_scales = "fixed")
RES$plot_CC_list


## ----"multiplot_allin1", message=FALSE, out.width="100%"--------------------------------------------------------------
RES <- CalibraCurve(D, plot_type = "all_in_one")
RES$plot_CC_list


## ----"CC_colours", message=FALSE--------------------------------------------------------------------------------------
RES <- CalibraCurve(D, point_colour = "blue", curve_colour = "black", 
                    linear_range_colour = "red")
RES$plot_CC_list[[1]]


## ----"RF_colours", message=FALSE--------------------------------------------------------------------------------------
RES <- CalibraCurve(D, RF_colour_threshold = "grey", 
                    RF_colour_within = "purple", 
                    RF_colour_outside = "darkgreen")
RES$plot_RF_list[[1]]


## ----"data_points", message=FALSE-------------------------------------------------------------------------------------
RES <- CalibraCurve(D, plot_type = "all_in_one", show_data_points = FALSE)
RES$plot_CC_list


## ----"regression_info", message=FALSE---------------------------------------------------------------------------------
RES <- CalibraCurve(D, show_linear_range = FALSE, show_regression_info = TRUE)
RES$plot_CC_list[[1]]


## ----"axis labels", message=FALSE-------------------------------------------------------------------------------------
RES <- CalibraCurve(D, xlab = "Amount (fmol)", ylab = "Area")
RES$plot_CC_list[[1]]


## ----"ggplot_object", message=FALSE-----------------------------------------------------------------------------------
RES <- CalibraCurve(D)
pl <- RES$plot_CC_list[[1]]

library(ggplot2)
pl <- pl + ggtitle("Calibration Curve") + theme_classic()
pl


## ----reproduce3, echo=FALSE-------------------------------------------------------------------------------------------
## Session info
library("sessioninfo")
options(width = 120)
session_info()

## ----Biblio, results = "asis", echo = FALSE, warning = FALSE, message = FALSE-----------------------------------------
## Print bibliography
PrintBibliography(bib, .opts = list(hyperlink = "to.doc", style = "html"))

