# ProteinGymR

## Data resources from ProteinGym

The `ProteinGymR` package provides analysis-ready data resources from 
[ProteinGym](https://proteingym.org), generated by [Notin et al., 
2023](https://proceedings.neurips.cc/paper_files/paper/2023/hash/cac723e5ff29f65e3fcbb0739ae91bee-Abstract-Datasets_and_Benchmarks.html). ProteinGym 
comprises a collection of benchmarks for evaluating the performance of models 
predicting the effect of point mutations. This package provides access to two 
datasets: 1. Deep mutational scanning (DMS) scores from 217 assays measuring
the impact of all possible amino acid substitutions across 186 proteins, and 2.
AlphaMissense pathogenicity scores for ~1.6 M substitutions in the ProteinGym 
DMS data.

<br>


## Installation

Install the package from Bioconductor or GitHub, ensuring correct
*Bioconductor* dependencies.

``` r
if (!"BiocManager" %in% rownames(installed.packages()))
    install.packages("BiocManager", repos = "https://cloud.R-project.org")

BiocManager::install("ccb-hms/ProteinGymR")
```

Load the library.

``` r
library(ProteinGymR)
```
