% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-xcmsRaw.R
\name{[,xcmsRaw,logicalOrNumeric,missing,missing-method}
\alias{[,xcmsRaw,logicalOrNumeric,missing,missing-method}
\alias{subset-xcmsRaw}
\title{Subset an xcmsRaw object by scans}
\usage{
\S4method{[}{xcmsRaw,logicalOrNumeric,missing,missing}(x, i, j, drop)
}
\arguments{
\item{x}{The \code{\linkS4class{xcmsRaw}} object that should be sub-setted.}

\item{i}{Integer or logical vector specifying the scans/spectra to which
\code{x} should be sub-setted.}

\item{j}{Not supported.}

\item{drop}{Not supported.}
}
\value{
The sub-setted \code{\linkS4class{xcmsRaw}} object.
}
\description{
Subset an \code{\linkS4class{xcmsRaw}} object by scans. The
    returned \code{\linkS4class{xcmsRaw}} object contains values for all
    scans specified with argument \code{i}. Note that the \code{scanrange}
    slot of the returned \code{xcmsRaw} will be
    \code{c(1, length(object@scantime))} and hence not \code{range(i)}.
}
\details{
Only subsetting by scan index in increasing order or by a logical
    vector are supported. If not ordered, argument \code{i} is sorted
    automatically. Indices which are larger than the total number of scans
    are discarded.
}
\examples{
## Load a test file
file <- system.file('cdf/KO/ko15.CDF', package = "faahKO")
xraw <- xcmsRaw(file, profstep = 0)
## The number of scans/spectra:
length(xraw@scantime)

## Subset the object to scans with a scan time from 3500 to 4000.
xsub <- xraw[xraw@scantime >= 3500 & xraw@scantime <= 4000]
range(xsub@scantime)
## The number of scans:
length(xsub@scantime)
## The number of values of the subset:
length(xsub@env$mz)
}
\seealso{
\code{\link{split.xcmsRaw}}
}
\author{
Johannes Rainer
}
