% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotQC.R
\name{plotQC}
\alias{plotQC}
\title{Plot m/z and RT deviations for QC purposes without external reference data}
\usage{
plotQC(object, sampNames, sampColors, sampOrder, what)
}
\arguments{
\item{object}{A grouped \code{\link{xcmsSet}}}

\item{sampNames}{Override sample names (e.g. with simplified names)}

\item{sampColors}{Provide a set of colors (default: monochrome ?)}

\item{sampOrder}{Override the order of samples, e.g. to bring them in order
of measurement to detect time drift}

\item{what}{A vector of which QC plots to generate.
"mzdevhist": histogram of mz deviations. Should be gaussian shaped. If it is multimodal, then some peaks seem to have a systematically higher m/z deviation
"rtdevhist":  histogram of RT deviations. Should be gaussian shaped. If it is multimodal, then some peaks seem to have a systematically higher RT deviation
"mzdevmass": Shows whether m/z deviations are absolute m/z dependent, could indicate miscalibration
"mzdevtime": Shows whether m/z deviations are RT dependent, could indicate instrument drift
"mzdevsample": median mz deviation for each sample, indicates outliers
"rtdevsample": median RT deviation for each sample, indicates outliers}
}
\value{
List with four matrices, each of dimension features * samples:
 "mz":    median mz deviation for each sample
 "mzdev": median mz deviation for each sample
 "rt":    median RT deviation for each sample
 "rtdev": median RT deviation for each sample
}
\description{
Use "democracy" to determine the average m/z and RT deviations
for a grouped xcmsSet, and dependency on sample or absolute m/z
}
\details{
plotQC() is a warpper to create a set of diagnostic plots.
For the m/z deviations, the median of all m/z withon one group are assumed.
}
\examples{
library(faahKO)
xsg <- group(faahko)

plotQC(xsg, what="mzdevhist")
plotQC(xsg, what="rtdevhist")
plotQC(xsg, what="mzdevmass")
plotQC(xsg, what="mzdevtime")
plotQC(xsg, what="mzdevsample")
plotQC(xsg, what="rtdevsample")

}
\author{
Michael Wenk, Michael Wenk <michael.wenk@student.uni-halle.de>
}
