% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_findChromPeaks-functions.R
\name{peaksWithMatchedFilter}
\alias{peaksWithMatchedFilter}
\title{Identify peaks in chromatographic data using matchedFilter}
\usage{
peaksWithMatchedFilter(
  int,
  rt,
  fwhm = 30,
  sigma = fwhm/2.3548,
  max = 20,
  snthresh = 10,
  ...
)
}
\arguments{
\item{int}{\code{numeric} with intensity values.}

\item{rt}{\code{numeric} with the retention time for the intensities. Length has
to be equal to \code{length(int)}.}

\item{fwhm}{\code{numeric(1)} specifying the full width at half maximum
of matched filtration gaussian model peak. Only used to calculate the
actual sigma, see below.}

\item{sigma}{\code{numeric(1)} specifying the standard deviation (width)
of the matched filtration model peak.}

\item{max}{\code{numeric(1)} with the maximal number of peaks that are expected/
will bbe detected in the data}

\item{snthresh}{\code{numeric(1)} defining the signal to noise cut-off to be used
in the peak detection step.}

\item{...}{currently ignored.}
}
\value{
A matrix, each row representing an identified chromatographic peak, with
columns:
\itemize{
\item \code{"rt"}: retention time of the peak's midpoint (time of the maximum signal).
\item \code{"rtmin"}: minimum retention time of the peak.
\item \code{"rtmax"}: maximum retention time of the peak.
\item \code{"into"}: integrated (original) intensity of the peak.
\item \code{"intf"}: integrated intensity of the filtered peak.
\item \code{"maxo"}: maximum (original) intensity of the peak.
\item \code{"maxf"}" maximum intensity of the filtered peak.
\item \code{"sn"}: signal to noise ratio of the peak.
}
}
\description{
The function performs peak detection using the \link{matchedFilter} algorithm
on chromatographic data (i.e. with only intensities and retention time).
}
\examples{

## Load the test file
faahko_sub <- loadXcmsData("faahko_sub")

## Subset to one file and drop identified chromatographic peaks
data <- dropChromPeaks(filterFile(faahko_sub, 1))

## Extract chromatographic data for a small m/z range
chr <- chromatogram(data, mz = c(272.1, 272.3), rt = c(3000, 3200))[1, 1]

pks <- peaksWithMatchedFilter(intensity(chr), rtime(chr))
pks

## Plotting the data
plot(rtime(chr), intensity(chr), type = "h")
rect(xleft = pks[, "rtmin"], xright = pks[, "rtmax"], ybottom = c(0, 0),
    ytop = pks[, "maxo"], border = "red")
}
\seealso{
\link{matchedFilter} for a detailed description of the peak detection
method.

Other peak detection functions for chromatographic data: 
\code{\link{peaksWithCentWave}()}
}
\author{
Johannes Rainer
}
\concept{peak detection functions for chromatographic data}
