% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataClasses.R, R/functions-Params.R,
%   R/methods-OnDiskMSnExp.R, R/methods-Params.R
\docType{class}
\name{findChromPeaks-massifquant}
\alias{findChromPeaks-massifquant}
\alias{massifquant}
\alias{MassifquantParam-class}
\alias{MassifquantParam}
\alias{findChromPeaks,OnDiskMSnExp,MassifquantParam-method}
\alias{ppm,MassifquantParam-method}
\alias{ppm<-,MassifquantParam-method}
\alias{peakwidth,MassifquantParam-method}
\alias{peakwidth<-,MassifquantParam-method}
\alias{snthresh,MassifquantParam-method}
\alias{snthresh<-,MassifquantParam-method}
\alias{prefilter,MassifquantParam-method}
\alias{prefilter<-,MassifquantParam-method}
\alias{mzCenterFun,MassifquantParam-method}
\alias{mzCenterFun<-,MassifquantParam-method}
\alias{integrate,MassifquantParam-method}
\alias{integrate<-,MassifquantParam-method}
\alias{mzdiff,MassifquantParam-method}
\alias{mzdiff<-,MassifquantParam-method}
\alias{fitgauss,MassifquantParam-method}
\alias{fitgauss<-,MassifquantParam-method}
\alias{noise,MassifquantParam-method}
\alias{noise<-,MassifquantParam-method}
\alias{verboseColumns,MassifquantParam-method}
\alias{verboseColumns<-,MassifquantParam-method}
\alias{criticalValue,MassifquantParam-method}
\alias{criticalValue}
\alias{criticalValue<-,MassifquantParam-method}
\alias{criticalValue<-}
\alias{consecMissedLimit,MassifquantParam-method}
\alias{consecMissedLimit}
\alias{consecMissedLimit<-,MassifquantParam-method}
\alias{consecMissedLimit<-}
\alias{unions,MassifquantParam-method}
\alias{unions}
\alias{unions<-,MassifquantParam-method}
\alias{unions<-}
\alias{checkBack,MassifquantParam-method}
\alias{checkBack}
\alias{checkBack<-,MassifquantParam-method}
\alias{checkBack<-}
\alias{withWave,MassifquantParam-method}
\alias{withWave}
\alias{withWave<-,MassifquantParam-method}
\alias{withWave<-}
\title{Chromatographic peak detection using the massifquant method}
\usage{
MassifquantParam(
  ppm = 25,
  peakwidth = c(20, 50),
  snthresh = 10,
  prefilter = c(3, 100),
  mzCenterFun = "wMean",
  integrate = 1L,
  mzdiff = -0.001,
  fitgauss = FALSE,
  noise = 0,
  verboseColumns = FALSE,
  criticalValue = 1.125,
  consecMissedLimit = 2,
  unions = 1,
  checkBack = 0,
  withWave = FALSE
)

\S4method{findChromPeaks}{OnDiskMSnExp,MassifquantParam}(
  object,
  param,
  BPPARAM = bpparam(),
  return.type = "XCMSnExp",
  msLevel = 1L,
  ...
)

\S4method{ppm}{MassifquantParam}(object)

\S4method{ppm}{MassifquantParam}(object) <- value

\S4method{peakwidth}{MassifquantParam}(object)

\S4method{peakwidth}{MassifquantParam}(object) <- value

\S4method{snthresh}{MassifquantParam}(object)

\S4method{snthresh}{MassifquantParam}(object) <- value

\S4method{prefilter}{MassifquantParam}(object)

\S4method{prefilter}{MassifquantParam}(object) <- value

\S4method{mzCenterFun}{MassifquantParam}(object)

\S4method{mzCenterFun}{MassifquantParam}(object) <- value

\S4method{integrate}{MassifquantParam}(f)

\S4method{integrate}{MassifquantParam}(object) <- value

\S4method{mzdiff}{MassifquantParam}(object)

\S4method{mzdiff}{MassifquantParam}(object) <- value

\S4method{fitgauss}{MassifquantParam}(object)

\S4method{fitgauss}{MassifquantParam}(object) <- value

\S4method{noise}{MassifquantParam}(object)

\S4method{noise}{MassifquantParam}(object) <- value

\S4method{verboseColumns}{MassifquantParam}(object)

\S4method{verboseColumns}{MassifquantParam}(object) <- value

\S4method{criticalValue}{MassifquantParam}(object)

\S4method{criticalValue}{MassifquantParam}(object) <- value

\S4method{consecMissedLimit}{MassifquantParam}(object)

\S4method{consecMissedLimit}{MassifquantParam}(object) <- value

\S4method{unions}{MassifquantParam}(object)

\S4method{unions}{MassifquantParam}(object) <- value

\S4method{checkBack}{MassifquantParam}(object)

\S4method{checkBack}{MassifquantParam}(object) <- value

\S4method{withWave}{MassifquantParam}(object)

\S4method{withWave}{MassifquantParam}(object) <- value
}
\arguments{
\item{ppm}{\code{numeric(1)} defining the maximal tolerated m/z deviation in
consecutive scans in parts per million (ppm) for the initial ROI
definition.}

\item{peakwidth}{\code{numeric(2)}. Only the first element is used by
massifquant, which specifices the minimum peak length in time scans.
For \code{withWave = TRUE} the second argument represents the maximum
peak length subject to being greater than the mininum peak length
(see also documentation of \code{\link{do_findChromPeaks_centWave}}).}

\item{snthresh}{\code{numeric(1)} defining the signal to noise ratio cutoff.}

\item{prefilter}{\code{numeric(2)}. The first argument is only used
if (\code{withWave = TRUE}); see \code{\link{findChromPeaks-centWave}}
for details. The second argument specifies the minimum threshold for the
maximum intensity of a chromatographic peak that must be met.}

\item{mzCenterFun}{Name of the function to calculate the m/z center of the
chromatographic peak. Allowed are: \code{"wMean"}: intensity weighted
mean of the peak's m/z values, \code{"mean"}: mean of the peak's m/z
values, \code{"apex"}: use the m/z value at the peak apex,
\code{"wMeanApex3"}: intensity weighted mean of the m/z value at the
peak apex and the m/z values left and right of it and \code{"meanApex3"}:
mean of the m/z value of the peak apex and the m/z values left and right
of it.}

\item{integrate}{Integration method. For \code{integrate = 1} peak limits
are found through descent on the mexican hat filtered data, for
\code{integrate = 2} the descent is done on the real data. The latter
method is more accurate but prone to noise, while the former is more
robust, but less exact.}

\item{mzdiff}{\code{numeric(1)} representing the minimum difference in m/z
dimension required for peaks with overlapping retention times; can be
negative to allow overlap. During peak post-processing, peaks
defined to be overlapping are reduced to the one peak with the largest
signal.}

\item{fitgauss}{\code{logical(1)} whether or not a Gaussian should be fitted
to each peak. This affects mostly the retention time position of the
peak.}

\item{noise}{\code{numeric(1)} allowing to set a minimum intensity required
for centroids to be considered in the first analysis step (centroids with
intensity \code{< noise} are omitted from ROI detection).}

\item{verboseColumns}{\code{logical(1)} whether additional peak meta data
columns should be returned.}

\item{criticalValue}{\code{numeric(1)}. Suggested values:
(\code{0.1-3.0}). This setting helps determine the the Kalman Filter
prediciton margin of error. A real centroid belonging to a bonafide
peak must fall within the KF prediction margin of error. Much like
in the construction of a confidence interval, \code{criticalVal} loosely
translates to be a multiplier of the standard error of the prediction
reported by the Kalman Filter. If the peak in the XC-MS sample have
a small mass deviance in ppm error, a smaller critical value might be
better and vice versa.}

\item{consecMissedLimit}{\code{integer(1)} Suggested values: (\code{1,2,3}).
While a peak is in the proces of being detected by a Kalman Filter, the
Kalman Filter may not find a predicted centroid in every scan. After 1
or more consecutive failed predictions, this setting informs Massifquant
when to stop a Kalman Filter from following a candidate peak.}

\item{unions}{\code{integer(1)} set to \code{1} if apply t-test union on
segmentation; set to \code{0} if no t-test to be applied on
chromatographically continous peaks sharing same m/z range.
Explanation: With very few data points, sometimes a Kalman Filter stops
tracking a peak prematurely. Another Kalman Filter is instantiated
and begins following the rest of the signal. Because tracking is done
backwards to forwards, this algorithmic defect leaves a real peak
divided into two segments or more. With this option turned on, the
program identifies segmented peaks and combines them (merges them)
into one with a two sample t-test. The potential danger of this option
is that some truly distinct peaks may be merged.}

\item{checkBack}{\code{integer(1)} set to \code{1} if turned on; set to
\code{0} if turned off. The convergence of a Kalman Filter to a peak's
precise m/z mapping is very fast, but sometimes it incorporates erroneous
centroids as part of a peak (especially early on). The \code{scanBack}
option is an attempt to remove the occasional outlier that lies beyond
the converged bounds of the Kalman Filter. The option does not directly
affect identification of a peak because it is a postprocessing measure;
it has not shown to be a extremely useful thus far and the default is set
to being turned off.}

\item{withWave}{\code{logical(1)} if \code{TRUE}, the peaks identified first
with Massifquant are subsequently filtered with the second step of the
centWave algorithm, which includes wavelet estimation.}

\item{object}{For \code{findChromPeaks}: an
    \code{\link{OnDiskMSnExp}} object containing the MS- and all
    other experiment-relevant data.

    For all other methods: a parameter object.}

\item{param}{An \code{MassifquantParam} object containing all settings for
the massifquant algorithm.}

\item{BPPARAM}{A parameter class specifying if and how parallel processing
should be performed. It defaults to \code{\link{bpparam}}.
See documentation of the \code{BiocParallel} for more details. If
parallel processing is enabled, peak detection is performed in parallel
on several of the input samples.}

\item{return.type}{Character specifying what type of object the method should
return. Can be either \code{"XCMSnExp"} (default), \code{"list"} or
\code{"xcmsSet"}.}

\item{msLevel}{\code{integer(1)} defining the MS level on which the peak
detection should be performed. Defaults to \code{msLevel = 1}.}

\item{...}{ignored.}

\item{value}{The value for the slot.}

\item{f}{For \code{integrate}: a \code{MassifquantParam} object.}
}
\value{
The \code{MassifquantParam} function returns a
    \code{MassifquantParam} class instance with all of the settings
    specified for chromatographic peak detection by the \emph{massifquant}
    method.

For \code{findChromPeaks}: if \code{return.type = "XCMSnExp"} an
    \code{\link{XCMSnExp}} object with the results of the peak detection.
    If \code{return.type = "list"} a list of length equal to the number of
    samples with matrices specifying the identified peaks.
    If \code{return.type = "xcmsSet"} an \code{\linkS4class{xcmsSet}} object
    with the results of the peak detection.
}
\description{
Massifquant is a Kalman filter (KF)-based chromatographic peak
    detection for XC-MS data in centroid mode. The identified peaks
    can be further refined with the \emph{centWave} method (see
    \code{\link{findChromPeaks-centWave}} for details on centWave)
    by specifying \code{withWave = TRUE}.

The \code{MassifquantParam} class allows to specify all
    settings for a chromatographic peak detection using the massifquant
    method eventually in combination with the centWave algorithm. Instances
    should be created with the \code{MassifquantParam} constructor.

The \code{findChromPeaks,OnDiskMSnExp,MassifquantParam}
    method performs chromatographic peak detection using the
    \emph{massifquant} algorithm on all samples from an
    \code{\link{OnDiskMSnExp}} object.
    \code{\link{OnDiskMSnExp}} objects encapsule all experiment
    specific data and load the spectra data (mz and intensity values) on the
    fly from the original files applying also all eventual data
    manipulations.

\code{ppm},\code{ppm<-}: getter and setter for the \code{ppm}
    slot of the object.

\code{peakwidth},\code{peakwidth<-}: getter and setter for the
    \code{peakwidth} slot of the object.

\code{snthresh},\code{snthresh<-}: getter and setter for the
    \code{snthresh} slot of the object.

\code{prefilter},\code{prefilter<-}: getter and setter for the
    \code{prefilter} slot of the object.

\code{mzCenterFun},\code{mzCenterFun<-}: getter and setter for the
    \code{mzCenterFun} slot of the object.

\code{integrate},\code{integrate<-}: getter and setter for the
    \code{integrate} slot of the object.

\code{mzdiff},\code{mzdiff<-}: getter and setter for the
    \code{mzdiff} slot of the object.

\code{fitgauss},\code{fitgauss<-}: getter and setter for the
    \code{fitgauss} slot of the object.

\code{noise},\code{noise<-}: getter and setter for the
    \code{noise} slot of the object.

\code{verboseColumns},\code{verboseColumns<-}: getter and
    setter for the \code{verboseColumns} slot of the object.

\code{criticalValue},\code{criticalValue<-}: getter and
    setter for the \code{criticalValue} slot of the object.

\code{consecMissedLimit},\code{consecMissedLimit<-}: getter and
    setter for the \code{consecMissedLimit} slot of the object.

\code{unions},\code{unions<-}: getter and
    setter for the \code{unions} slot of the object.

\code{checkBack},\code{checkBack<-}: getter and
    setter for the \code{checkBack} slot of the object.

\code{withWave},\code{withWave<-}: getter and
    setter for the \code{withWave} slot of the object.
}
\details{
This algorithm's performance has been tested rigorously
    on high resolution LC/(OrbiTrap, TOF)-MS data in centroid mode.
    Simultaneous kalman filters identify chromatographic peaks and calculate
    their area under the curve. The default parameters are set to operate on
    a complex LC-MS Orbitrap sample. Users will find it useful to do some
    simple exploratory data analysis to find out where to set a minimum
    intensity, and identify how many scans an average peak spans. The
    \code{consecMissedLimit} parameter has yielded good performance on
    Orbitrap data when set to (\code{2}) and on TOF data it was found best
    to be at (\code{1}). This may change as the algorithm has yet to be
    tested on many samples. The \code{criticalValue} parameter is perhaps
    most dificult to dial in appropriately and visual inspection of peak
    identification is the best suggested tool for quick optimization.
    The \code{ppm} and \code{checkBack} parameters have shown less influence
    than the other parameters and exist to give users flexibility and
    better accuracy.

Parallel processing (one process per sample) is supported and can
    be configured either by the \code{BPPARAM} parameter or by globally
    defining the parallel processing mode using the
    \code{\link{register}} method from the \code{BiocParallel}
    package.
}
\section{Slots}{

\describe{
\item{\code{ppm,peakwidth,snthresh,prefilter,mzCenterFun,integrate,mzdiff,fitgauss,noise,verboseColumns,criticalValue,consecMissedLimit,unions,checkBack,withWave}}{See corresponding parameter above. Slots values should
exclusively be accessed \emph{via} the corresponding getter and setter
methods listed above.}
}}

\note{
These methods and classes are part of the updated and modernized
    \code{xcms} user interface which will eventually replace the
    \code{\link{findPeaks}} methods. It supports chromatographic peak
    detection on
    \code{\link{OnDiskMSnExp}} objects (defined in the
    \code{MSnbase} package). All of the settings to the massifquant and
    centWave algorithm can be passed with a \code{MassifquantParam} object.
}
\examples{

## Create a MassifquantParam object.
mqp <- MassifquantParam()
## Change snthresh prefilter parameters
snthresh(mqp) <- 30
prefilter(mqp) <- c(6, 10000)
mqp

## Perform the peak detection using massifquant on the files from the
## faahKO package. Files are read using the readMSData from the MSnbase
## package
library(faahKO)
library(MSnbase)
fls <- dir(system.file("cdf/KO", package = "faahKO"), recursive = TRUE,
           full.names = TRUE)
raw_data <- readMSData(fls[1], mode = "onDisk")
## Perform the peak detection using the settings defined above.
res <- findChromPeaks(raw_data, param = mqp)
head(chromPeaks(res))
}
\references{
Conley CJ, Smith R, Torgrip RJ, Taylor RM, Tautenhahn R and Prince JT
"Massifquant: open-source Kalman filter-based XC-MS isotope trace feature
detection" \emph{Bioinformatics} 2014, 30(18):2636-43.
}
\seealso{
The \code{\link{do_findChromPeaks_massifquant}} core API function
    and \code{\link{findPeaks.massifquant}} for the old user interface.

\code{\link{XCMSnExp}} for the object containing the results of
    the peak detection.

Other peak detection methods: 
\code{\link{findChromPeaks}()},
\code{\link{findChromPeaks-centWave}},
\code{\link{findChromPeaks-centWaveWithPredIsoROIs}},
\code{\link{findChromPeaks-matchedFilter}},
\code{\link{findPeaks-MSW}}
}
\author{
Christopher Conley, Johannes Rainer
}
\concept{peak detection methods}
