% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-Chromatogram.R,
%   R/methods-MChromatograms.R
\name{correlate,Chromatogram,Chromatogram-method}
\alias{correlate,Chromatogram,Chromatogram-method}
\alias{correlate}
\alias{correlate,MChromatograms,missing-method}
\alias{correlate,MChromatograms,MChromatograms-method}
\title{Correlate chromatograms}
\usage{
\S4method{correlate}{Chromatogram,Chromatogram}(
  x,
  y,
  use = "pairwise.complete.obs",
  method = c("pearson", "kendall", "spearman"),
  align = c("closest", "approx"),
  ...
)

\S4method{correlate}{MChromatograms,missing}(
  x,
  y = NULL,
  use = "pairwise.complete.obs",
  method = c("pearson", "kendall", "spearman"),
  align = c("closest", "approx"),
  ...
)

\S4method{correlate}{MChromatograms,MChromatograms}(
  x,
  y = NULL,
  use = "pairwise.complete.obs",
  method = c("pearson", "kendall", "spearman"),
  align = c("closest", "approx"),
  ...
)
}
\arguments{
\item{x}{\code{\link[MSnbase:Chromatogram-class]{MSnbase::Chromatogram()}} or \code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}} object.}

\item{y}{\code{\link[MSnbase:Chromatogram-class]{MSnbase::Chromatogram()}} or \code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}} object.}

\item{use}{\code{character(1)} passed to the \code{cor} function. See \code{\link[=cor]{cor()}} for
details.}

\item{method}{\code{character(1)} passed to the \code{cor} function. See
\code{\link[stats:cor]{stats::cor()}} for details.}

\item{align}{\code{character(1)} defining the alignment method to be used. See
help on \code{alignRt} in \code{\link[MSnbase:Chromatogram-class]{MSnbase::Chromatogram()}} for details. The value of
this parameter is passed to the \code{method} parameter of \code{alignRt}.}

\item{...}{optional parameters passed along to the \code{alignRt} method such as
\code{tolerance} that, if set to \code{0} requires the retention times to be
identical.}
}
\value{
\code{numeric(1)} or \code{matrix} (if called on \code{MChromatograms} objects)
with the correlation coefficient. If a \code{matrix} is returned, the rows
represent the chromatograms in \code{x} and the columns the chromatograms in
\code{y}.
}
\description{
\strong{For \code{xcms} >= 3.15.3 please use \code{\link[=compareChromatograms]{compareChromatograms()}} instead of
\code{correlate}}

Correlate intensities of two chromatograms with each other. If the two
\code{Chromatogram} objects have different retention times they are first
\emph{aligned} to match data points in the first to data points in the second
chromatogram. See help on \code{alignRt} in \code{\link[MSnbase:Chromatogram-class]{MSnbase::Chromatogram()}} for more
details.

If \code{correlate} is called on a single \code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}} object a
pairwise correlation of each chromatogram with each other is performed and
a \code{matrix} with the correlation coefficients is returned.

Note that the correlation of two chromatograms depends also on their order,
e.g. \code{correlate(chr1, chr2)} might not be identical to
\code{correlate(chr2, chr1)}. The lower and upper triangular part of the
correlation matrix might thus be different.
}
\examples{

library(MSnbase)
chr1 <- Chromatogram(rtime = 1:10 + rnorm(n = 10, sd = 0.3),
    intensity = c(5, 29, 50, NA, 100, 12, 3, 4, 1, 3))
chr2 <- Chromatogram(rtime = 1:10 + rnorm(n = 10, sd = 0.3),
    intensity = c(80, 50, 20, 10, 9, 4, 3, 4, 1, 3))
chr3 <- Chromatogram(rtime = 3:9 + rnorm(7, sd = 0.3),
    intensity = c(53, 80, 130, 15, 5, 3, 2))

chrs <- MChromatograms(list(chr1, chr2, chr3))

## Using `compareChromatograms` instead of `correlate`.
compareChromatograms(chr1, chr2)
compareChromatograms(chr2, chr1)

compareChromatograms(chrs, chrs)
}
\author{
Michael Witting, Johannes Rainer
}
