% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/XcmsExperiment.R,
%   R/functions-Params.R, R/functions-XCMSnExp.R, R/methods-OnDiskMSnExp.R,
%   R/methods-Params.R, R/methods-XCMSnExp.R
\name{adjustRtime}
\alias{adjustRtime}
\alias{ObiwarpParam-class}
\alias{PeakGroupsParam-class}
\alias{adjustRtime,MsExperiment,ObiwarpParam-method}
\alias{adjustRtime,MsExperiment,PeakGroupsParam-method}
\alias{PeakGroupsParam}
\alias{ObiwarpParam}
\alias{adjustRtimePeakGroups}
\alias{adjustRtime,OnDiskMSnExp,ObiwarpParam-method}
\alias{minFraction,PeakGroupsParam-method}
\alias{minFraction<-,PeakGroupsParam-method}
\alias{extraPeaks,PeakGroupsParam-method}
\alias{extraPeaks}
\alias{extraPeaks<-,PeakGroupsParam-method}
\alias{extraPeaks<-}
\alias{smooth,PeakGroupsParam-method}
\alias{smooth}
\alias{smooth<-,PeakGroupsParam-method}
\alias{smooth<-}
\alias{span,PeakGroupsParam-method}
\alias{span}
\alias{span<-,PeakGroupsParam-method}
\alias{span<-}
\alias{family,PeakGroupsParam-method}
\alias{family}
\alias{family<-,PeakGroupsParam-method}
\alias{family<-}
\alias{peakGroupsMatrix,PeakGroupsParam-method}
\alias{peakGroupsMatrix}
\alias{peakGroupsMatrix<-,PeakGroupsParam-method}
\alias{peakGroupsMatrix<-}
\alias{subset,PeakGroupsParam-method}
\alias{subset}
\alias{subset<-,PeakGroupsParam-method}
\alias{subset<-}
\alias{subsetAdjust,PeakGroupsParam-method}
\alias{subsetAdjust}
\alias{subsetAdjust<-,PeakGroupsParam-method}
\alias{subsetAdjust<-}
\alias{binSize,ObiwarpParam-method}
\alias{binSize<-,ObiwarpParam-method}
\alias{centerSample,ObiwarpParam-method}
\alias{centerSample}
\alias{centerSample<-,ObiwarpParam-method}
\alias{centerSample<-}
\alias{response,ObiwarpParam-method}
\alias{response}
\alias{response<-,ObiwarpParam-method}
\alias{response<-}
\alias{distFun,ObiwarpParam-method}
\alias{distFun}
\alias{distFun<-,ObiwarpParam-method}
\alias{distFun<-}
\alias{gapInit,ObiwarpParam-method}
\alias{gapInit}
\alias{gapInit<-,ObiwarpParam-method}
\alias{gapInit<-}
\alias{gapExtend,ObiwarpParam-method}
\alias{gapExtend}
\alias{gapExtend<-,ObiwarpParam-method}
\alias{gapExtend<-}
\alias{factorDiag,ObiwarpParam-method}
\alias{factorDiag}
\alias{factorDiag<-,ObiwarpParam-method}
\alias{factorDiag<-}
\alias{factorGap,ObiwarpParam-method}
\alias{factorGap}
\alias{factorGap<-,ObiwarpParam-method}
\alias{factorGap<-}
\alias{localAlignment,ObiwarpParam-method}
\alias{localAlignment}
\alias{localAlignment<-,ObiwarpParam-method}
\alias{localAlignment<-}
\alias{initPenalty,ObiwarpParam-method}
\alias{initPenalty}
\alias{initPenalty<-,ObiwarpParam-method}
\alias{initPenalty<-}
\alias{subset,ObiwarpParam-method}
\alias{subset<-,ObiwarpParam-method}
\alias{subsetAdjust,ObiwarpParam-method}
\alias{subsetAdjust<-,ObiwarpParam-method}
\alias{adjustRtime,XCMSnExp,PeakGroupsParam-method}
\alias{adjustRtime,XCMSnExp,ObiwarpParam-method}
\title{Alignment: Retention time correction methods.}
\usage{
adjustRtime(object, param, ...)

\S4method{adjustRtime}{MsExperiment,ObiwarpParam}(object, param, chunkSize = 2L, BPPARAM = bpparam())

\S4method{adjustRtime}{MsExperiment,PeakGroupsParam}(object, param, msLevel = 1L, ...)

PeakGroupsParam(
  minFraction = 0.9,
  extraPeaks = 1,
  smooth = "loess",
  span = 0.2,
  family = "gaussian",
  peakGroupsMatrix = matrix(nrow = 0, ncol = 0),
  subset = integer(),
  subsetAdjust = c("average", "previous")
)

ObiwarpParam(
  binSize = 1,
  centerSample = integer(),
  response = 1L,
  distFun = "cor_opt",
  gapInit = numeric(),
  gapExtend = numeric(),
  factorDiag = 2,
  factorGap = 1,
  localAlignment = FALSE,
  initPenalty = 0,
  subset = integer(),
  subsetAdjust = c("average", "previous"),
  rtimeDifferenceThreshold = 5
)

adjustRtimePeakGroups(object, param = PeakGroupsParam(), msLevel = 1L)

\S4method{adjustRtime}{OnDiskMSnExp,ObiwarpParam}(object, param, msLevel = 1L)

\S4method{minFraction}{PeakGroupsParam}(object)

\S4method{minFraction}{PeakGroupsParam}(object) <- value

\S4method{extraPeaks}{PeakGroupsParam}(object)

\S4method{extraPeaks}{PeakGroupsParam}(object) <- value

\S4method{smooth}{PeakGroupsParam}(x)

\S4method{smooth}{PeakGroupsParam}(object) <- value

\S4method{span}{PeakGroupsParam}(object)

\S4method{span}{PeakGroupsParam}(object) <- value

\S4method{family}{PeakGroupsParam}(object)

\S4method{family}{PeakGroupsParam}(object) <- value

\S4method{peakGroupsMatrix}{PeakGroupsParam}(object)

\S4method{peakGroupsMatrix}{PeakGroupsParam}(object) <- value

\S4method{subset}{PeakGroupsParam}(x)

\S4method{subset}{PeakGroupsParam}(object) <- value

\S4method{subsetAdjust}{PeakGroupsParam}(object)

\S4method{subsetAdjust}{PeakGroupsParam}(object) <- value

\S4method{binSize}{ObiwarpParam}(object)

\S4method{binSize}{ObiwarpParam}(object) <- value

\S4method{centerSample}{ObiwarpParam}(object)

\S4method{centerSample}{ObiwarpParam}(object) <- value

\S4method{response}{ObiwarpParam}(object)

\S4method{response}{ObiwarpParam}(object) <- value

\S4method{distFun}{ObiwarpParam}(object)

\S4method{distFun}{ObiwarpParam}(object) <- value

\S4method{gapInit}{ObiwarpParam}(object)

\S4method{gapInit}{ObiwarpParam}(object) <- value

\S4method{gapExtend}{ObiwarpParam}(object)

\S4method{gapExtend}{ObiwarpParam}(object) <- value

\S4method{factorDiag}{ObiwarpParam}(object)

\S4method{factorDiag}{ObiwarpParam}(object) <- value

\S4method{factorGap}{ObiwarpParam}(object)

\S4method{factorGap}{ObiwarpParam}(object) <- value

\S4method{localAlignment}{ObiwarpParam}(object)

\S4method{localAlignment}{ObiwarpParam}(object) <- value

\S4method{initPenalty}{ObiwarpParam}(object)

\S4method{initPenalty}{ObiwarpParam}(object) <- value

\S4method{subset}{ObiwarpParam}(x)

\S4method{subset}{ObiwarpParam}(object) <- value

\S4method{subsetAdjust}{ObiwarpParam}(object)

\S4method{subsetAdjust}{ObiwarpParam}(object) <- value

\S4method{adjustRtime}{XCMSnExp,PeakGroupsParam}(object, param, msLevel = 1L)

\S4method{adjustRtime}{XCMSnExp,ObiwarpParam}(object, param, msLevel = 1L)
}
\arguments{
\item{object}{For \code{adjustRtime}: an \code{\link[MSnbase:OnDiskMSnExp-class]{MSnbase::OnDiskMSnExp()}}, \code{\link[=XCMSnExp]{XCMSnExp()}},
\code{\link[MsExperiment:MsExperiment]{MsExperiment::MsExperiment()}} or \code{\link[=XcmsExperiment]{XcmsExperiment()}} object.}

\item{param}{The parameter object defining the alignment method (and its
setting).}

\item{...}{ignored.}

\item{chunkSize}{For \code{adjustRtime} if \code{object} is either an \code{MsExperiment} or
\code{XcmsExperiment}: \code{integer(1)} defining the number of files (samples)
that should be loaded into memory and processed at the same time.
Alignment is then performed in parallel (per sample) on this subset of
loaded data. This setting thus allows to balance between memory
demand and speed (due to parallel processing). Because parallel
processing can only performed on the subset of data currently loaded
into memory in each iteration, the value for \code{chunkSize} should match
the defined  parallel setting setup. Using a parallel processing setup
using 4 CPUs (separate processes) but using \verb{chunkSize = }1\verb{will not perform any parallel processing, as only the data from one sample is loaded in memory at a time. On the other hand, setting}chunkSize` to
the total number of samples in an experiment will load the full MS data
into memory and will thus in most settings cause an out-of-memory error.}

\item{BPPARAM}{parallel processing setup. Defaults to \code{BPPARAM = bpparam()}.
See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for details.}

\item{msLevel}{For \code{adjustRtime}: \code{integer(1)} defining the MS level on
which the alignment should be performed.}

\item{minFraction}{For \code{PeakGroupsParam}: \code{numeric(1)} between 0 and 1
defining the minimum required proportion of samples in which peaks for
the peak group were identified. Peak groups passing this criteria will
be aligned across samples and retention times of individual spectra will
be adjusted based on this alignment. For \code{minFraction = 1} the peak
group has to contain peaks in all samples of the experiment. Note that if
\code{subset} is provided, the specified fraction is relative to the
defined subset of samples and not to the total number of samples within
the experiment (i.e., a peak has to be present in the specified
proportion of subset samples).}

\item{extraPeaks}{For \code{PeakGroupsParam}: \code{numeric(1)} defining the maximal
number of additional peaks for all samples to be assigned to a peak
group (feature) for retention time correction. For a data set with 6
samples, \code{extraPeaks = 1} uses all peak groups with a total peak count
\verb{<= 6 + 1}. The total peak count is the total number of peaks being
assigned to a peak group and considers also multiple peaks within a
sample that are assigned to the group.}

\item{smooth}{For \code{PeakGroupsParam}: \code{character(1)} defining the function to
be used to interpolate corrected retention times for all peak groups.
Can be either \code{"loess"} or \code{"linear"}.}

\item{span}{For \code{PeakGroupsParam}: \code{numeric(1)} defining
the degree of smoothing (if \code{smooth = "loess"}). This parameter is
passed to the internal call to \code{\link[stats:loess]{stats::loess()}}.}

\item{family}{For \code{PeakGroupsParam}: \code{character(1)} defining the method for
loess smoothing. Allowed values are \code{"gaussian"} and \code{"symmetric"}. See
\code{\link[stats:loess]{stats::loess()}} for more information.}

\item{peakGroupsMatrix}{For \code{PeakGroupsParam}: optional \code{matrix} of (raw)
retention times for the (marker) peak groups on which the alignment
should be performed. Each column represents a sample, each row a
feature/peak group. The \code{adjustRtimePeakGroups} method is used by
default to determine this matrix on the provided \code{object}.}

\item{subset}{For \code{ObiwarpParam} and \code{PeakGroupsParam}: \code{integer} with the
indices of samples within the experiment on which the alignment models
should be estimated.
Samples not part of the subset are adjusted based on the closest subset
sample. See \emph{Subset-based alignment} section for details.}

\item{subsetAdjust}{For \code{ObiwarpParam} and \code{PeakGroupsParam}: \code{character(1)}
specifying the method with which non-subset samples should be adjusted.
Supported options are \code{"previous"} and \code{"average"} (default).
See \emph{Subset-based alignment} section for details.}

\item{binSize}{\code{numeric(1)} defining the bin size (in mz dimension)
to be used for the \emph{profile matrix} generation. See \code{step}
parameter in \code{\link{profile-matrix}} documentation for more details.}

\item{centerSample}{\code{integer(1)} defining the index of the center sample
in the experiment. It defaults to
\code{floor(median(1:length(fileNames(object))))}. Note that if
\code{subset} is used, the index passed with \code{centerSample} is
within these subset samples.}

\item{response}{For \code{ObiwarpParam}: \code{numeric(1)} defining the
\emph{responsiveness} of warping with \code{response = 0} giving linear warping on
start and end points and \code{response = 100} warping using all bijective
anchors.}

\item{distFun}{For \code{ObiwarpParam}: \code{character(1)} defining the distance
function to be used. Allowed values are \code{"cor"} (Pearson's correlation),
\code{"cor_opt"} (calculate only 10\% diagonal band of distance matrix;
better runtime), \code{"cov"} (covariance), \code{"prd"} (product) and \code{"euc"}
(Euclidian distance). The default value is \code{distFun = "cor_opt"}.}

\item{gapInit}{For \code{ObiwarpParam}: \code{numeric(1)} defining the penalty for gap
opening. The default value for depends on the value of \code{distFun}:
\code{distFun = "cor"} and \code{distFun = "cor_opt"} it is \code{0.3}, for
\code{distFun = "cov"} and \code{distFun = "prd"} \code{0.0} and for \code{distFun = "euc"}
\code{0.9}.}

\item{gapExtend}{For \code{ObiwarpParam}: \code{numeric(1)} defining the penalty for
gap enlargement. The default value for \code{gapExtend} depends on the value
of \code{distFun}: for \code{distFun = "cor"} and \code{distFun = "cor_opt"} it is
\code{2.4}, \code{distFun = "cov"} \code{11.7}, for \code{distFun = "euc"} \code{1.8} and for
\code{distFun = "prd"} \code{7.8}.}

\item{factorDiag}{For \code{ObiwarpParam}: \code{numeric(1)} defining the local weight
applied to diagonal moves in the alignment.}

\item{factorGap}{For \code{ObiwarpParam}: \code{numeric(1)} defining the local weight
for gap moves in the alignment.}

\item{localAlignment}{For \code{ObiwarpParam}: \code{logical(1)} whether a local
alignment should be performed instead of the default global alignment.}

\item{initPenalty}{For \code{ObiwarpParam}: \code{numeric(1)} defining the penalty for
initiating an alignment (for local alignment only).}

\item{rtimeDifferenceThreshold}{For \code{ObiwarpParam}: \code{numeric(1)} defining
the threshold to identify a \emph{gap} in the sequence of retention times of
(MS1) spectra of a sample/file. A gap is defined if the difference in
retention times between consecutive spectra is
\verb{> rtimeDifferenceThreshold} of the median observed difference or
retenion times of that data sample/file. Spectra with an retention time
after such a \emph{gap} will not be adjusted. The default for this parameter
is \code{rtimeDifferenceThreshold = 5}. For Waters data with lockmass scans
or LC-MS/MS data this might however be a too low threshold and it should
be increased. See also
\href{https://github.com/sneumann/xcms/issues/739}{issue #739}.}

\item{value}{The value for the slot.}

\item{x}{An \code{ObiwarpParam}, \code{PeakGroupsParam} or \code{LamaParama} object.}
}
\value{
\code{adjustRtime} on an \code{OnDiskMSnExp} or \code{XCMSnExp} object will return an
\code{XCMSnExp} object with the alignment results.

\code{adjustRtime} on an \code{MsExperiment} or \code{XcmsExperiment} will return an
\code{XcmsExperiment} with the adjusted retention times stored in an new
\emph{spectra variable} \code{rtime_adjusted} in the object's \code{spectra}.

\code{ObiwarpParam}, \code{PeakGroupsParam} and \code{LamaParama} return the respective
parameter object.

\code{adjustRtimeGroups} returns a \code{matrix} with the retention times of \emph{marker}
features in each sample (each row one feature, each row one sample).
}
\description{
The \code{adjustRtime} method(s) perform retention time correction (alignment)
between chromatograms of different samples/dataset. Alignment is performed
by default on MS level 1 data. Retention times of spectra from other MS
levels, if present, are subsequently adjusted based on the adjusted
retention times of the MS1 spectra. Note that calling \code{adjustRtime} on a
\emph{xcms} result object will remove any eventually present previous alignment
results as well as any correspondence analysis results. To run a second
round of alignment, raw retention times need to be replaced with adjusted
ones using the \code{\link[=applyAdjustedRtime]{applyAdjustedRtime()}} function.

The alignment method can be specified (and configured) using a dedicated
\code{param} argument.

Supported \code{param} objects are:
\itemize{
\item \code{ObiwarpParam}: performs retention time adjustment based on the full m/z -
rt data using the \emph{obiwarp} method (Prince (2006)). It is based on the
\href{http://obi-warp.sourceforge.net}{original code} but supports in addition
alignment of multiple samples by aligning each against a \emph{center} sample.
The alignment is performed directly on the \link{profile-matrix} and can hence
be performed independently of the peak detection or peak grouping.
\item \code{PeakGroupsParam}: performs retention time correction based on the
alignment of features defined in all/most samples (corresponding to
\emph{house keeping compounds} or marker compounds) (Smith 2006). First the
retention time deviation of these features is described by fitting either a
polynomial (\code{smooth = "loess"}) or a linear (\code{smooth = "linear"}) function
to the data points. These are then subsequently used to adjust the
retention time of each spectrum in each sample (even from spectra of
MS levels different than MS 1). Since the function is
based on features (i.e. chromatographic peaks grouped across samples) a
initial correspondence analysis has to be performed \strong{before} using the
\code{\link[=groupChromPeaks]{groupChromPeaks()}} function. Alternatively, it is also possible to
manually define a \code{numeric} matrix with retention times of markers in each
samples that should be used for alignment. Such a \code{matrix} can be passed
to the alignment function using the \code{peakGroupsMatrix} parameter of the
\code{PeakGroupsParam} parameter object. By default the \code{adjustRtimePeakGroups}
function is used to define this \code{matrix}. This function identifies peak
groups (features) for alignment in \code{object} based on the parameters defined
in \code{param}. See also \code{\link[=do_adjustRtime_peakGroups]{do_adjustRtime_peakGroups()}} for the core API
function.
\item \code{LamaParama}: This function performs retention time correction by aligning
chromatographic data to an external reference dataset (concept and initial
implementation by Carl Brunius). The process involves identifying and
aligning peaks within the experimental chromatographic data, represented
as an \code{XcmsExperiment} object, to a predefined set of landmark features
called "lamas". These landmark features are characterized by their
mass-to-charge ratio (m/z) and retention time. see \code{\link[=LamaParama]{LamaParama()}} for more
information on the method.
}
}
\section{Subset-based alignment}{


All alignment methods allow to perform the retention time correction on a
user-selected subset of samples (e.g. QC samples) after which all samples
not part of that subset will be adjusted based on the adjusted retention
times of the \emph{closest} subset sample (close in terms of index within \code{object}
and hence possibly injection index). It is thus suggested to load MS data
files in the order in which their samples were injected in the measurement
run(s).

How the non-subset samples are adjusted depends also on the parameter
\code{subsetAdjust}: with \code{subsetAdjust = "previous"}, each non-subset
sample is adjusted based on the closest \emph{previous} subset sample which
results in most cases with adjusted retention times of the non-subset
sample being identical to the subset sample on which the adjustment bases.
The second, default, option is \code{subsetAdjust = "average"} in which case
each non subset sample is adjusted based on the average retention time
adjustment from the previous and following subset sample. For the average,
a weighted mean is used with weights being the inverse of the distance of
the non-subset sample to the subset samples used for alignment.

See also section \emph{Alignment of experiments including blanks} in the
\emph{xcms} vignette for more details.
}

\references{
Prince, J. T., and Marcotte, E. M. (2006) "Chromatographic Alignment of
ESI-LC-MS Proteomic Data Sets by Ordered Bijective Interpolated Warping"
\emph{Anal. Chem.}, 78 (17), 6140-6152.

Smith, C.A., Want, E.J., O'Maille, G., Abagyan, R. and Siuzdak, G. (2006).
"XCMS: Processing Mass Spectrometry Data for Metabolite Profiling Using
Nonlinear Peak Alignment, Matching, and Identification" \emph{Anal. Chem.}
78:779-787.
}
\seealso{
\code{\link[=plotAdjustedRtime]{plotAdjustedRtime()}} for visualization of alignment results.
}
\author{
Colin Smith, Johannes Rainer, Philippine Louail, Carl Brunius
}
\concept{retention time correction methods}
