% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-XCMSnExp.R
\name{quantify,XCMSnExp-method}
\alias{quantify,XCMSnExp-method}
\alias{featureValues,XCMSnExp-method}
\alias{featureValues}
\title{Accessing mz-rt feature data values}
\usage{
\S4method{quantify}{XCMSnExp}(object, ...)

\S4method{featureValues}{XCMSnExp}(
  object,
  method = c("medret", "maxint", "sum"),
  value = "into",
  intensity = "into",
  filled = TRUE,
  missing = NA,
  msLevel = integer()
)
}
\arguments{
\item{object}{A \code{\link{XCMSnExp}} object providing the feature
definitions.}

\item{...}{For \code{quantify}: additional parameters to be passed on to the
\code{\link{featureValues}} method.}

\item{method}{\code{character} specifying the method to resolve
multi-peak mappings within the same sample, i.e. to define the
\emph{representative} peak for a feature in samples where more than
one peak was assigned to the feature. If \code{"medret"}: select the
peak closest to the median retention time of the feature.
If \code{"maxint"}: select the peak yielding the largest signal. If
\code{"sum"}: sum the values (only if \code{value} is \code{"into"} or
\code{"maxo"}.}

\item{value}{\code{character} specifying the name of the column in
\code{chromPeaks(object)} that should be returned. Defaults to
\code{"into"} in which case the integrated peak area is returned. To
get the index of the peak in the \code{chromPeaks(object)} matrix use
\code{"index"}.}

\item{intensity}{\code{character} specifying the name of the column in the
\code{chromPeaks(objects)} matrix containing the intensity value of the
peak that should be used for the conflict resolution if
\code{method = "maxint"}.}

\item{filled}{\code{logical(1)} specifying whether values for filled-in
peaks should be returned or not. If \code{filled = FALSE}, an \code{NA}
is returned in the matrix for the respective peak. See
\code{\link{fillChromPeaks}} for details on peak filling.}

\item{missing}{how missing values should be reported. Allowed values are
\code{NA} (the default), a \code{numeric} or
\code{missing = "rowmin_half"}. The latter replaces any \code{NA} with
half of the row's minimal (non-missing) value.}

\item{msLevel}{for `featureValues`: `integer` defining the MS level(s) for
which feature values should be returned. By default, values for features
defined for all MS levels are returned.}
}
\value{
For \code{featureValues}: a \code{matrix} with
feature values, columns representing samples, rows features. The order
of the features matches the order found in the
\code{featureDefinitions(object)} \code{DataFrame}. The rownames of the
\code{matrix} are the same than those of the \code{featureDefinitions}
\code{DataFrame}. \code{NA} is reported for features without
corresponding chromatographic peak in the respective sample(s).

For \code{quantify}: a \code{\link{SummarizedExperiment}} representing
the preprocessing results.
}
\description{
\code{featureValues,XCMSnExp} : extract a \code{matrix} for
feature values with rows representing features and columns samples.
Parameter \code{value} allows to define which column from the
\code{\link{chromPeaks}} matrix should be returned. Multiple
chromatographic peaks from the same sample can be assigned to a feature.
Parameter \code{method} allows to specify the method to be used in such
cases to chose from which of the peaks the value should be returned.
Parameter `msLevel` allows to choose a specific MS level for which feature
values should be returned (given that features have been defined for that MS
level).

\code{quantify,XCMSnExp}: return the preprocessing results as an
\code{\link{SummarizedExperiment}} object containing the feature abundances
as assay matrix, the feature definitions (returned by
\code{\link{featureDefinitions}}) as \code{rowData} and the phenotype
information as \code{colData}. This is an ideal container for further
processing of the data. Internally, the \code{\link{featureValues}} method
is used to extract the feature abundances, parameters for that method can
be passed to \code{quantify} with \code{...}.
}
\note{
This method is equivalent to the \code{\link{groupval}} for
\code{xcmsSet} objects. Note that \code{missing = 0} should be used to
get the same behaviour as \code{groupval}, i.e. report missing values as 0
after a call to \code{fillPeaks}.
}
\seealso{
\code{\link{XCMSnExp}} for information on the data object.

\code{\link{featureDefinitions}} to extract the \code{DataFrame} with the
feature definitions.

\code{\link{featureChromatograms}} to extract ion chromatograms for each
feature.

\code{\link{hasFeatures}} to evaluate whether the
\code{\link{XCMSnExp}} provides feature definitions.

\code{\link{groupval}} for the equivalent method on \code{xcmsSet} objects.
}
\author{
Johannes Rainer
}
