% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPlotting.R
\name{plotSCEDensityColData}
\alias{plotSCEDensityColData}
\title{Density plot of colData.}
\usage{
plotSCEDensityColData(
  inSCE,
  coldata,
  sample = NULL,
  groupBy = NULL,
  xlab = NULL,
  ylab = NULL,
  baseSize = 12,
  axisSize = NULL,
  axisLabelSize = NULL,
  defaultTheme = TRUE,
  title = NULL,
  titleSize = 18,
  cutoff = NULL,
  combinePlot = "none",
  plotLabels = NULL
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object with saved
dimension reduction components or a variable with saved results. Required.}

\item{coldata}{colData value that will be plotted.}

\item{sample}{Character vector. Indicates which sample each cell belongs to.}

\item{groupBy}{Groupings for each numeric value. A user may input a vector
equal length to the number of the samples in the SingleCellExperiment
object, or can be retrieved from the colData slot. Default NULL.}

\item{xlab}{Character vector. Label for x-axis. Default NULL.}

\item{ylab}{Character vector. Label for y-axis. Default NULL.}

\item{baseSize}{The base font size for all text. Default 12.
Can be overwritten by titleSize, axisSize, and axisLabelSize,
legendSize, legendTitleSize.}

\item{axisSize}{Size of x/y-axis ticks. Default NULL.}

\item{axisLabelSize}{Size of x/y-axis labels. Default NULL.}

\item{defaultTheme}{Removes grid in plot and sets axis title size to 10
when TRUE. Default TRUE.}

\item{title}{Title of plot. Default NULL.}

\item{titleSize}{Size of title of plot. Default 15.}

\item{cutoff}{Numeric value. The plot will be annotated with a vertical line
if set. Default NULL.}

\item{combinePlot}{Must be either "all", "sample", or "none". "all" will combine all plots into a single
.ggplot object, while "sample" will output a list of plots separated by sample. Default "none".}

\item{plotLabels}{labels to each plot. If set to "default", will use the name of the samples
as the labels. If set to "none", no label will be plotted.}
}
\value{
a ggplot of the density plot of colData.
}
\description{
Visualizes values stored in the colData slot of a
 SingleCellExperiment object via a density plot.
}
\examples{
data("mouseBrainSubsetSCE")
plotSCEDensityColData(
  inSCE = mouseBrainSubsetSCE,
  coldata = "age", groupBy = "sex"
)
}
