% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omXplore_view_dataset.R
\name{ds-view}
\alias{ds-view}
\alias{view_dataset_ui}
\alias{view_dataset_server}
\alias{view_dataset}
\title{Bar plot of missing values per lines using \code{highcharter}.}
\usage{
view_dataset_ui(id)

view_dataset_server(
  id,
  dataIn = reactive({
     NULL
 }),
  addons = list(),
  useModal = TRUE,
  verbose = FALSE
)

view_dataset(dataIn = NULL, addons = NULL, useModal = TRUE)
}
\arguments{
\item{id}{A \code{character(1)} for the 'id' of the shiny module. It must be
the same as for the '*_ui' function.}

\item{dataIn}{An instance of the class \code{MultiAssayExperiment}.}

\item{addons}{A \code{list} to configure the other shiny apps to integrate.
Each item correspond to one package:
\itemize{
\item the name of the slot is the name of the package
\item the content of the slot is a vector composed of the generic name of the
shiny app. Each of the apps listed here must be an exported app of the
package.
For example, given the value addons = list(testPkg = c('foo', 'foo2')). That
means that the package called "testPkg" must provide the four functions:
foo1_ui(), foo1_server() and foo2_ui(), foo2_server())
}}

\item{useModal}{A \code{boolean(1)} that indicates whether to open plot modules
in a modal window or not. Default is TRUE.}

\item{verbose}{A boolean for verbose mode. Default is FALSE.}
}
\value{
NA

NA

NA

A shiny application which wraps the functions view_dataset_ui()
and the view_dataset_server()
}
\description{
This method plots a bar plot which represents the distribution of the
number of missing values (NA) per lines (i.e. proteins).
}
\details{
\itemize{
\item distribution of the missing values per line,
\item a bar plot which represents the distribution of the
number of missing values (NA) per lines (i.e. proteins) and per conditions,
\item Histogram of missing values.
\item Variance : Builds a densityplot of the CV of entities in numeric matrix.
The CV is calculated for each condition present in the dataset
(see the slot \code{'Condition'} in the \code{colData()} DataFrame)
\item Heatmap:
}

The function \code{\link[=heatmapD]{heatmapD()}}

The function [] is inspired from the function 'heatmap.2'
that displays a numeric matrix. For more information, please refer to the
help of the heatmap.2 function.
}
\section{Missing values}{


#' - distribution of the missing values per line,
\itemize{
\item a bar plot which represents the distribution of the
number of missing values (NA) per lines (ie proteins) and per conditions,
\item Histogram of missing values.
}
}

\examples{
if (interactive()) {
    data(vdata)
    addons <- list(omXplore = c("extFoo1", "extFoo2"))
    runApp(view_dataset(vdata, addons))

    shiny::runApp(omXplore::view_dataset(vdata))
}

if (interactive()) {
    data(vdata)
    view_dataset(vdata)
}

}
\author{
Samuel Wieczorek, Enora Fremy
}
