library(extraChIPs)
library(BSgenome.Hsapiens.UCSC.hg19)
library(S7)
genome <- BSgenome.Hsapiens.UCSC.hg19

esr1 <- structure(
    ## Taken from HOCOMOCO v12
    c(
        0.226744, 0.26938, 0.275194, 0.228682, 0.275194, 0.275194, 0.313953,
        0.135659, 0.023256, 0.005814, 0.005814, 0.965116, 0.011628, 0.003876,
        0.965116, 0.01938, 0.903101, 0.087209, 0.003876, 0.005814, 0.027132,
        0.94186, 0.013566, 0.017442, 0.236434, 0.738372, 0.001938, 0.023256,
        0.079457, 0.273256, 0.017442, 0.629845, 0.290698, 0.114341, 0.337209,
        0.257752
    ),
    dim = c(4L, 9L),
    dimnames = list(
        c("A", "C", "G", "T"), c("N", "V", "T", "G", "A", "C", "C", "Y", "D")
    )
)
stringset <- DNAStringSet(
    c(seq1 = "GGATTGTCACAAGAGCAGAGGAGTTGGGGGAGTGCCAATGGCATGTGGTGGATAAGGGCCAAGGAGGCTGCTAAACATCCTACAGGGCACAGAACACCCCCCACCCACCCACCCACCCCCACCATCCAAGATTATCCTGCCCCAAATGTCAACAGTGCTGAGGTTGAGAAAGCCTGGGATAGGGACACAGCGGAGGGGAACTCAGACAGGACGGGGTCAGAGAAGAGACAGGAAAAGGTCAGCCTGCCCTGTAGCTACTGAACCCTCCCTCCCCACAACCCCCTTGCTCTGTGTGGGCCTTTGGTCTCTTCTTTTGTCTCCCGCCCTGCTTCTCTCCTCTATCTCTTTGGTGTTGTCCCTGTTTATTTCTGTTTATCTCTCGGTCTCCATTTCTCACTCA")
)

data("ex_pfm")
data("ar_er_peaks")
data("ar_er_seq")
sq <- seqinfo(ar_er_peaks)
seq <- ar_er_seq

set.seed(305)
data("hg19_mask")
bg_ranges <- makeRMRanges(ar_er_peaks, GRanges(sq)[1], exclude = hg19_mask, n_iter = 10)

um_db <- c(
    universalmotif::create_motif(
        structure(
            c(
                0.322855, 0.180588, 0.26099, 0.235567, 0.31117, 0.125298, 0.425207,
                0.138325, 0.402504, 0.063908, 0.472497, 0.061091, 0.057876, 0.052724,
                0.817663, 0.071737, 0.05339, 0.05687, 0.71068, 0.17906, 0.047178,
                0.140192, 0.091133, 0.721497, 0.121482, 0.682831, 0.090312, 0.105376,
                0.859135, 0.037395, 0.054401, 0.04907, 0.809751, 0.016653, 0.115958,
                0.057638, 0.896698, 0.003516, 0.096138, 0.003648, 0.003741, 0.003159,
                0.949124,  0.043976, 0.005324, 0.003377, 0.943629, 0.04767, 0.006563,
                0.019202, 0.041509, 0.932726, 0.014678, 0.875439, 0.03702, 0.072863,
                0.833528, 0.027008, 0.116974, 0.02249, 0.316355, 0.259421, 0.141642,
                0.282581, 0.248762, 0.187929, 0.420157, 0.143152
            ), dim = c(4L, 17L), dimnames = list(c("A", "C", "G", "T"), NULL)
        ), "DNA", name = "COT1/RXRB/RXRG/NR4A1/NR2C2", altname = "Test1",
        pseudocount = 1, nsites = 100
    ),
    universalmotif::create_motif(
        structure(
            c(
                0.42957, 0.132867, 0.337662, 0.0999, 0.715542, 0.041922, 0.139241,
                0.103295, 0.672629, 0.041425, 0.204112, 0.081833, 0.674648, 0.010476,
                0.102304, 0.212572, 0.115749, 0.056397, 0.815379, 0.012476, 0.686661,
                0.066865, 0.241982, 0.004492, 0.054378, 0, 0.945622, 0, 0.000499,
                5e-04, 0.999002, 0, 0.999002, 0.000998, 0, 0, 0.996011, 0.000499,
                0.000997, 0.002494, 0.023943, 0.167643, 0.807915, 0.000499, 0.029456,
                0.018973, 0.006985, 0.944586, 0.007987, 0.089874, 0.896147, 0.005992,
                0.452983, 0.183201, 0.29193, 0.071886, 0.410768, 0.144566, 0.317049,
                0.127617, 0.535394, 0.130608, 0.177468, 0.15653, 0.216351, 0.306082,
                0.309073, 0.168495
            ), dim = c(4L, 17L), dimnames = list(c("A", "C", "G", "T"), NULL)
        ), "DNA", name = "SPIB/SPI1", altname = "Test2", pseudocount = 1, nsites = 100
    )
)

