% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_enrichment.R
\name{.iterativeNormForKmers}
\alias{.iterativeNormForKmers}
\title{Adjust for k-mer composition (multiple iterations)}
\usage{
.iterativeNormForKmers(
  df,
  maxKmerSize = 3L,
  minSeqWgt = 0.001,
  maxIter = 160L,
  verbose = FALSE
)
}
\arguments{
\item{df}{A \code{DataFrame} with sequence information as returned by
\code{.calculateGCweight}.}

\item{maxKmerSize}{Integer scalar giving the maximum k-mer size to
consider. The default is set to 3 (like in \code{HOMER}), meaning that
k-mers of size 1, 2 and 3 are considered.}

\item{minSeqWgt}{Numeric scalar greater than zero giving the
minimal weight of a sequence. The default value (0.001) was also used by
\code{HOMER} (HOMER_MINIMUM_SEQ_WEIGHT  constant in Motif2.h).}

\item{maxIter}{An integer scalar giving the maximum number if
times to run \code{.normForKmers}. the default is set to 160 (as in
\code{HOMER}).}

\item{verbose}{A logical scalar. If \code{TRUE}, report on k-mer composition
adjustment.}
}
\value{
A \code{DataFrame} containing: \describe{ \item{sequenceWeights}{: a
  \code{dataframe} containing the sequence GC content, GC bins they were
  assigned to, the weight to correct for GC differences between foreGround
  and background sequences, the weight to adjust for kmer composition, and
  the the error term} \item{sequenceNucleotides}{: a \code{DNAStringSet}
  object containing the raw sequences} }
}
\description{
Here we run `.normForKmers` multiple times to converge to
  the final weights that will be used to correct the background
  sequences for k-mer composition differences compared to the foreground. We
  closely follow \code{HOMER}'s \code{normalizeSequence()} function found in
  \code{Motif2.cpp}. Note that \code{HOMER} runs the
  \code{normalizeSequence()} one last time after going through all iterations
  or reaching a low error, which we do not do here.
}
\keyword{internal}
