% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmpPcaEffects.R
\name{lmpPcaEffects}
\alias{lmpPcaEffects}
\title{PCA on the effect matrices}
\usage{
lmpPcaEffects(
  resLmpEffectMatrices,
  method = c("ASCA", "APCA", "ASCA-E"),
  combineEffects = NULL,
  verbose = FALSE
)
}
\arguments{
\item{resLmpEffectMatrices}{A resLmpEffectMatrices list resulting of \code{\link{lmpEffectMatrices}}.}

\item{method}{The method used to compute the PCA. One of \code{c("ASCA","APCA","ASCA-E")}.}

\item{combineEffects}{If not \code{NULL}, a list of vectors containing the names of the effects to be combined.}

\item{verbose}{If \code{TRUE}, will display a message with the duration of execution.}
}
\value{
A list with first,the PCA results from \code{\link{pcaBySvd}} for each effect matrix. Those results contain :
\describe{
\item{\code{scores}}{Scores from the PCA for each principal component.}
\item{\code{loadings}}{Loadings from the PCA for each principal component.}
\item{\code{eigval}}{Eigenvalues of each principal component.}
\item{\code{singvar}}{Singular values of each principal component.}
\item{\code{var}}{Explained variances of each principal component.}
\item{\code{cumvar}}{Cumulated explained variances of each principal component.}
\item{\code{original.dataset}}{Original dataset.}
}

There are also others outputs :
\describe{
\item{\code{lmpDataList}}{The initial object: a list of outcomes, design and formula.}
\item{\code{effectsNamesUnique}}{A character vector with the \emph{F+1} names of the model terms, each repeated once.}
\item{\code{method}}{The dimension reduction method used: \code{c("ASCA","APCA","ASCA-E")}.}
\item{\code{type3SS}}{A vector with the type III SS for each model term.}
\item{\code{variationPercentages}}{A vector with the percentage of variance explained by each model term.}
}
}
\description{
Performs a PCA on each of the effect matrices from the outputs of \code{\link{lmpEffectMatrices}}. It has an option to choose the method applied: ASCA, APCA or ASCA-E. Combined effects (i.e. linear combinations of original effect matrices) can also be created and decomposed by PCA.
}
\details{
The function allows 3 different methods :

\describe{
\item{ASCA}{PCA is applied directly on each pure effect matrix \eqn{\hat{\mathbf{M}}_f, f=1...F}.}
\item{ASCA-E}{PCA is applied on each pure effect matrix but then the augmented effect matrix is projected in the space of the ASCA components.}
\item{APCA}{PCA is applied on each augmented effect matrix : \eqn{\hat{\mathbf{M}}_f+\hat{\mathbf{E}}}.}
}
}
\examples{
data("UCH")
resLmpModelMatrix <- lmpModelMatrix(UCH)
resLmpEffectMatrices <- lmpEffectMatrices(resLmpModelMatrix)
resLmpPcaEffects <- lmpPcaEffects(resLmpEffectMatrices, method = "ASCA-E")

}
\references{
Thiel M.,Feraud B. and Govaerts B. (2017) ASCA+ and APCA+: Extensions of ASCA and APCA
in the analysis of unbalanced multifactorial designs. \emph{Journal of Chemometrics}. 31:e2895.
\url{https://doi.org/10.1002/cem.2895}
}
