% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiomics.R
\name{run_cnv_integration}
\alias{run_cnv_integration}
\title{Integration of expression and Copy Number Variations}
\usage{
run_cnv_integration(
  expression,
  cnv_data,
  sequencing_data = TRUE,
  normalize = TRUE,
  norm_method = "TMM",
  class = NULL,
  run_deg = TRUE,
  BPPARAM = SerialParam(),
  ...
)
}
\arguments{
\item{expression}{Matrix or data.frame containing the expression values
for each model. Rows represent samples, while each column represents
the different response variables of the models.}

\item{cnv_data}{Matrix or data.frame containing the Copy Number variation
status for the models. Rows represent samples, while columns represent
the different covariates. If \strong{interactions} are not provided, they will be
automatically generated and for each gene contained in \strong{expression}
the model will look for the same gene in \strong{cnv_data}}

\item{sequencing_data}{logical. Are expression data obtained from RNA
sequencing ? Default is set to TRUE}

\item{normalize}{logical.Should expression data be
normalized ? Default is set to TRUE}

\item{norm_method}{Normalization method to be used for
expression data. One of "TMM" (default), "TMMwsp", "RLE", "upperquartile",
"none".}

\item{class}{Character vector specifying the classes for differential
expression analysis.}

\item{run_deg}{Logical. Should differential expression analysis be performed?
Default is set to TRUE.}

\item{BPPARAM}{A BiocParallelParam object specifying the parallel backend to
be used.}

\item{...}{Additional arguments to be passed to internal functions.}
}
\value{
A list or a \linkS4class{MultiClass} object if \strong{class} is provided
containing the results of the CNV integration
}
\description{
This function will perform an integration of expression data and Copy Number
Variations data
}
\examples{
# Example usage_multi:
library(MultiAssayExperiment)
data("mmultiassay_ov")
tmp <- lapply(experiments(mmultiassay_ov), function(x) x[1:20,])
mmultiassay_ov <- MultiAssayExperiment(experiments = tmp)
gene_cnv_matrix <- t(as.matrix(assay(mmultiassay_ov[["cnv_data"]])))
gene_exp_matrix <- t(as.matrix(assay(mmultiassay_ov[["gene_exp"]])))
cnv_integration <- run_cnv_integration(
    expression = gene_exp_matrix,
    cnv_data = gene_cnv_matrix
)
}
