% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF.R
\name{meanDifferences}
\alias{meanDifferences}
\title{meanDifferences}
\usage{
meanDifferences(estimated, observed)
}
\arguments{
\item{estimated}{a two column data.frame, output of \code{\link{fitNB}},
\code{\link{fitZINB}}, \code{\link{fitDM}}, \code{\link{fitZIG}}, or
\code{\link{fitHURDLE}} functions. More in general, a data frame
containing the continuity corrected logarithm for the average of the fitted
values for each row of a matrix of counts in the \code{Y} column, and the
estimated probability to observe a zero in the \code{Y0} column.}

\item{observed}{a two column data.frame, output of
\code{\link{prepareObserved}} function. More in general, a data frame
containing the continuity corrected logarithm for the average of the observed
values for each row of a matrix of counts in the \code{Y} column, and the
estimated proportion of zeroes in the \code{Y0} column.}
}
\value{
a \code{data.frame} containing the differences between the estimated
and the observed continuity corrected logarithms of the average count values
in the \code{MD} column, and between the estimated average probability to
observe a zero and the the observed zero rate in the \code{ZPD} column.
}
\description{
Compute the differences between the estimated and the observed continuity
corrected logarithms of the average count values (MD), and between the
estimated average probability to observe a zero and the the observed zero
rate (ZPD).
}
\examples{
# Randomly generate the observed and estimated data.frames
observed <- data.frame(Y = rpois(10, 5), Y0 = runif(10, 0, 1))
estimated <- data.frame(Y = rpois(10, 5), Y0 = runif(10, 0, 1))

# Compute the mean differences between estimated and observed data.frames
meanDifferences(estimated, observed)
}
\seealso{
\code{\link{prepareObserved}}.
}
