% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordance.R
\name{CAT}
\alias{CAT}
\title{CAT}
\usage{
CAT(vec1, vec2, maxrank = min(length(vec1), length(vec2)))
}
\arguments{
\item{vec1, vec2}{Two numeric vectors, for computing concordance. If these 
are numeric vectors with names, the numeric values will be used for sorting 
and the names will be used for calculating concordance. Otherwise, they are 
assumed to be already-ranked vectors, and the values themselves will be 
used for calculating concordance.}

\item{maxrank}{Optionally specify the maximum size of top-ranked items that 
you want to plot.}
}
\value{
a data.frame with two columns: \code{rank} containing the length of 
the top lists and \code{concordance} which is the fraction in common that 
the two provided lists have in the top \code{rank} items.
}
\description{
For the i top-ranked members of each list, concordance is defined as 
\code{length(intersect(vec1[1:i],vec2[1:i]))/i}.
}
\examples{
vec1 <- c("A" = 10, "B" = 5, "C" = 20, "D" = 15)
vec2 <- c("A" = 1, "B" = 2, "C" = 3, "D" = 4)

CAT(vec1, vec2)
}
\seealso{
\code{\link{createConcordance}}.
}
