% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contactsUMI4C.R
\name{.singleCounterUMI4C}
\alias{.singleCounterUMI4C}
\title{Count UMIs for a given bam file.}
\usage{
.singleCounterUMI4C(
  filtered_bam_R1,
  filtered_bam_R2,
  digested_genome_gr,
  pos_viewpoint,
  res_enz,
  count_dir,
  filter_bp = 1e+07
)
}
\arguments{
\item{filtered_bam_R1}{R1 bam file.}

\item{filtered_bam_R2}{R2 bam file.}

\item{digested_genome_gr}{GRanges object containing the coordinates for the
digested genome.}

\item{pos_viewpoint}{Vector consist of chromosome, start and end position of
the viewpoint.}

\item{res_enz}{Character containing the restriction enzyme sequence.}

\item{count_dir}{Counter directory.}

\item{filter_bp}{Integer indicating the bp upstream and downstream of the
viewpoint to select for further analysis. Default=10e6}
}
\value{
Creates a tab-delimited file in \code{wk_dir/count} named
"\code{basename(fastq) _counts.tsv}", containing the
coordinates for the viewpoint fragment, contact fragment and the number of
UMIs detected in the ligation.
}
\description{
Count UMIs for a given bam file.
}
