#' UMI4Cats: A package for analyzing UMI-4C chromatin contact data
#'
#' The UMI4Cats package provides functions for the pre-processing, analysis and
#' visualization of UMI-4C chromatin contact data.
#'
#' @section File preparation:
#' There are two different functions that can be used to prepare the files
#' for analyzing them with UMI4Cats:
#' \enumerate{
#'     \item \code{\link{demultiplexFastq}}. Demultiplex reads belonging to
#'     different viewpoints from a paired-end FastQ file.
#'     \item \code{\link{digestGenome}}. Digest the reference genome of choice
#'     using a given restriction sequence.
#' }
#'
#' @section Processing:
#' The pre-processing functions are wrapped in the \code{\link{contactsUMI4C}}
#' main function. This function will sequentially run the following steps:
#' \enumerate{
#'     \item \code{\link{prepUMI4C}}. Filter specific and high quality reads.
#'     \item \code{\link{splitUMI4C}}. Split reads by the restriction sequence.
#'     \item \code{\link{alignmentUMI4C}}. Align reads to the reference genome.
#'     \item \code{\link{counterUMI4C}}. Apply UMI counting algorithm to quantify
#'     the interactions with the viewpoint.
#' }
#'
#' The statistics from the samples analyzed with the \code{\link{contactsUMI4C}}
#' function can be extracted and visualized with the function
#' \code{\link{statsUMI4C}}.
#'
#' @section Analysis:
#' The analysis of UMI-4C data is wrapped in the construction of an object of
#' \linkS4class{UMI4C} class by the creator function \code{\link{makeUMI4C}}.
#' This function will group your samples according to the variable you provided
#' in the \code{grouping} argument (default: "condition") and then normalize it
#' to \code{ref_umi4c}.
#' 
#' Significant interactions with the viewpoint can be called when several 
#' replicates are available, using the \code{\link{callInteractions}} function. 
#' A set of \code{query_regions}, such as enhancers or open chromatin regions
#' needs to be provided. When no candidate regions are available, one can use
#' the function \code{\link{makeWindowFragments}} to join a fixed number of 
#' restriction fragments into windows. The results of this analysis can be 
#' visualized using \code{\link{plotInteractionsUMI4C}} and the list of 
#' significant interactions can be retrieved using 
#' \code{\link{getSignInteractions}}. 
#'
#' The differential analysis can be performed with 
#' \code{\link{fisherUMI4C}} or \code{\link{waldUMI4C}} functions and can be 
#' focused in a set of regions of interest by providing the \code{query_regions}
#'  argument. Both will return a \linkS4class{UMI4C} object containing the 
#' results of the differential test. You can access these results with the 
#' method \code{\link{resultsUMI4C}}.
#'
#' @section Visualization:
#' An integrative plot showing the results stored inside the \linkS4class{UMI4C}
#' object can be generated with the function \code{\link{plotUMI4C}}.
#'
#' @docType package
#' @name UMI4Cats
NULL

utils::globalVariables(c(
    "factors", "scales", "value",
    "hg19_gene_annoation_ensemblv75", "stepping",
    "gene_name", "geo_coord", "grouping_var",
    "relative_position", "sample_id", "al_mapped",
    "al_unmapped", "variable",
    "queryHits", "subjectHits", "subsetByOverlaps",
    "assay", "metadata", "rowRanges", "assays", "assays<-",
    "assay", "colData", "IRanges", "SimpleList",
    "metadata<-", "rowRanges<-", "UMIs", "refs", "predict",
    "design<-", "formula", "estimateDispersions", "mid", "counts",
    "zscore", "sample_num"
))

#' Contacs with CIITA promoter
#'
#' An example UMI4C object showing the contacts with a viewpoint located at 
#' the CIITA gene promoter.
#'
#' @format A UMI4C object from this package.
#' @source See inst/script/CIITA_process_example.R to see the code use for generating
#' the UMI4C object.
"ex_ciita_umi4c"
