% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R
\name{export.mutex}
\alias{export.mutex}
\title{export,mutex}
\usage{
export.mutex(
  x,
  filename = "tronco_to_mutex",
  filepath = "./",
  label.mutation = "SNV",
  label.amplification = list("High-level Gain"),
  label.deletion = list("Homozygous Loss")
)
}
\arguments{
\item{x}{A TRONCO compliant dataset.}

\item{filename}{The name of the file}

\item{filepath}{The path where to save the file}

\item{label.mutation}{The event type to use as mutation}

\item{label.amplification}{The event type to use as amplification (can be a list)}

\item{label.deletion}{The event type to use as amplification (can be a list)}
}
\value{
A MUTEX example matrix
}
\description{
Create an input file for MUTEX
(ref: https://code.google.com/p/mutex/ )
}
\examples{
data(crc_gistic)
dataset = import.GISTIC(crc_gistic)
export.mutex(dataset)

}
