% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.functions.R
\name{as.marginal.probs}
\alias{as.marginal.probs}
\title{as.marginal.probs}
\usage{
as.marginal.probs(
  x,
  events = as.events(x),
  models = names(x$model),
  type = "observed"
)
}
\arguments{
\item{x}{A TRONCO model.}

\item{events}{A subset of events as of \code{as.events(x)}, all by default.}

\item{models}{A subset of reconstructed models, all by default.}

\item{type}{observed.}
}
\value{
The marginal probabilities in a TRONCO model.
}
\description{
Extract the marginal probabilities from a TRONCO model. The return matrix is indexed with rownames which 
represent genotype keys - these can be resolved with function \code{keysToNames}. It is possible to
specify a subset of events to build the matrix, a subset of models if multiple reconstruction have
been performed. Also, either the observed or fit probabilities can be extracted.
}
\examples{
data(test_model)
as.marginal.probs(test_model)
as.marginal.probs(test_model, events=as.events(test_model)[5:15,])

}
