% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.functions.R
\name{as.alterations}
\alias{as.alterations}
\title{as.alterations}
\usage{
as.alterations(x, new.type = "Alteration", new.color = "khaki", silent = FALSE)
}
\arguments{
\item{x}{A TRONCO compliant dataset.}

\item{new.type}{The types label of the new event type, 'Alteration' by default.}

\item{new.color}{The color of the event \code{new.type}, default 'khaki'.}

\item{silent}{A parameter to disable/enable verbose messages.}
}
\value{
A TRONCO compliant dataset with alteration profiles.
}
\description{
Return a dataset where all events for a gene are merged in a unique event, i.e., 
a total of gene-level alterations diregarding the event type. Input 'x' is checked
to be a TRONCO compliant dataset - see \code{is.compliant}.
}
\examples{
data(muts)
as.alterations(muts)

}
