#### TRONCO: a tool for TRanslational ONCOlogy
####
#### Copyright (c) 2015-2017, Marco Antoniotti, Giulio Caravagna, Luca De Sano,
#### Alex Graudenzi, Giancarlo Mauri, Bud Mishra and Daniele Ramazzotti.
####
#### All rights reserved. This program and the accompanying materials
#### are made available under the terms of the GNU GPL v3.0
#### which accompanies this distribution.


#' @name maf
#' @title MAF example data
#' @description This dataset contains a standard MAF input for TRONCO 
#' @docType data
#' @usage data(maf)
#' @format Manual Annotated Format
#' @source fake data
#' @author Luca De Sano
#' @return A standard TRONCO object
NULL

#' @name muts
#' @title Simple mutation dataset
#' @description A simple mutation dataset without hypotheses
#' @docType data
#' @usage data(muts)
#' @format TRONCO compliant dataset
#' @source fake data
#' @author Luca De Sano
#' @return A standard TRONCO object
NULL

#' @name test_dataset_no_hypos
#' @title A complete dataset
#' @description This dataset contains a complete test dataset
#' @docType data
#' @usage data(test_dataset_no_hypos)
#' @format TRONCO compliant dataset
#' @source fake data
#' @author Luca De Sano
#' @return A standard TRONCO object
NULL

#' @name test_dataset
#' @title A complete dataset with hypotheses
#' @description This dataset contains a complete test dataset
#' @docType data
#' @usage data(test_dataset)
#' @format TRONCO compliant dataset
#' @source fake data
#' @author Luca De Sano
#' @return A standard TRONCO object
NULL

#' @name stage
#' @title Stage information for test_dataset
#' @description This dataset contains stage information for patient in test_dataset
#' @docType data
#' @usage data(stage)
#' @format Vector of stages
#' @source fake data
#' @author Luca De Sano
#' @return A list of stages
NULL

#' @name test_model
#' @title A complete dataset with a reconstructed model
#' @description This dataset contains a model reconstructed with CAPRI
#' @docType data
#' @usage data(test_model)
#' @format TRONCO compliant dataset
#' @source fake data
#' @author Luca De Sano
#' @return A standard TRONCO object
NULL

#' @name test_model_kfold
#' @title A complete dataset with a reconstructed model and crossvalidation informations
#' @description This dataset contains a model reconstructed with CAPRI
#' @docType data
#' @usage data(test_model_kfold)
#' @format TRONCO compliant dataset
#' @source fake data
#' @author Luca De Sano
#' @return A standard TRONCO object
NULL

#' @name aCML
#' @title Atypical chronic myeloid leukemia dataset
#' @description This file contains a TRONCO compliant dataset 
#' @docType data
#' @usage data(aCML)
#' @format TRONCO compliant dataset
#' @source data from http://www.nature.com/ng/journal/v45/n1/full/ng.2495.html
#' @author Luca De Sano
#' @return A standard TRONCO object
NULL

#' @name crc_maf
#' @title MAF example data
#' @description This dataset contains an example of MAF input of a crc cohort of patients 
#' @docType data
#' @usage data(crc_maf)
#' @format Manual Annotated Format
#' @source data from http://www.nature.com/nature/journal/v487/n7407/full/nature11252.html
#' @author Daniele Ramazzotti
#' @return A MAF file
NULL

#' @name crc_gistic
#' @title GISTIC example data
#' @description This dataset contains an example of GISTIC input of a crc cohort of patients 
#' @docType data
#' @usage data(crc_gistic)
#' @format GISTIC score
#' @source data from http://www.nature.com/nature/journal/v487/n7407/full/nature11252.html
#' @author Daniele Ramazzotti
#' @return A gistic file
NULL

#' @name crc_plain
#' @title Plain mutation dataset
#' @description This dataset contains an example of plain input of a crc cohort of patients
#' @docType data
#' @usage data(crc_plain)
#' @format plain data
#' @source data from http://www.nature.com/nature/journal/v487/n7407/full/nature11252.html
#' @author Daniele Ramazzotti
#' @return A plain input
NULL
