% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPCA.R
\name{plotPCA}
\alias{plotPCA}
\title{plotPCA function}
\usage{
plotPCA(
  matrix,
  metadata,
  nTOP = 500,
  dims = c(1, 2),
  centering = TRUE,
  scaling = TRUE,
  color.by = NULL,
  shape.by = NULL,
  pt.size = 6,
  cols.use = NULL,
  shape.use = NULL,
  main = "PCA",
  label = FALSE,
  new.label = NULL
)
}
\arguments{
\item{matrix}{Filtered count matrix in CPM or RPKM with gene on the row and sample ID on the column.}

\item{metadata}{Sample metadata, row.names must be samples names.}

\item{nTOP}{number of top genes to use for principal components,
selected by highest row variance}

\item{dims}{Dimensions to plot, must be a two-length numeric vector specifying x- and y-dimensions}

\item{centering}{Logical. If \code{TRUE} center PCs}

\item{scaling}{Logical. If \code{TRUE} scales PCs}

\item{color.by}{Name of one or more metadata columns to color point by.}

\item{shape.by}{Name of one or more metadata columns to shape point by. If NULL, all points are circles \(default\).}

\item{pt.size}{Size of the points in the plot.}

\item{cols.use}{Vector of colors, each color corresponds to an identity class.
By default, ggplot assigns colors.}

\item{shape.use}{Vector of shape, each shape corresponds to an identity class.}

\item{main}{Plot title. Default = PCA.}

\item{label}{Logical. If \code{TRUE} adds samples label. Default = FALSE.}

\item{new.label}{If NULL, use the sample names as in metadata row.names.
Otherwise you can specify new labels.}
}
\value{
PCA plot objec created by ggplot2,
which can be assigned and further customized.
}
\description{
Plot PCA highlighting one or two data features
}
\examples{
\dontrun{
# Simulation of bulk RNA data
countData <- matrix(floor(runif(10000, min=0, max=101)),ncol=4)
colnames(countData) <- paste("sample", seq_len(ncol(countData)), sep = "")
rownames(countData) <- paste("gene", seq_along(seq_len(10000/4)), sep = "")
metadata <- data.frame(samplesID = paste("sample", seq_len(ncol(countData)), sep = ""),
                     condition = factor(c("A","A","B","B")),
                     therapy = factor(c("T1","T2","T1","T2")))
row.names(metadata) <- metadata$samplesID
library(edgeR)
SurfR::plotPCA(matrix = cpm(countData),
        metadata = metadata,
        nTOP = 100,
        dims = c(1,2),
        color.by = "condition", shape.by = "therapy",
        label = FALSE, main = "PCA")}
}
\seealso{
Other plot functions: 
\code{\link{Enrichment_barplot}()},
\code{\link{SVenn}()},
\code{\link{Splot}()}
}
\concept{plot functions}
