% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Splot.R
\name{Splot}
\alias{Splot}
\title{Splot function}
\usage{
Splot(
  SurfaceProteins_df,
  group.by = "Membranome.Almen.main-class",
  cols.use = NULL,
  main = "Almen main class"
)
}
\arguments{
\item{SurfaceProteins_df}{Output dataframe of Gene2SProtein function.}

\item{group.by}{Name of columns to plot. Default = Membranome.Almen.main-class.}

\item{cols.use}{Vector of colors, each color corresponds to an identity class.
By default, ggplot assigns colors.}

\item{main}{Plot title. Default = Almen main class.}
}
\value{
plot objec created by ggplot2,
which can be assigned and further customized.
}
\description{
Plot a barplot with features of Surface Protein
}
\examples{
\dontrun{
GeneNames <- c("CIITA", "EPCAM", "DLK1", "CD24", "CDCP1", "LYVE1", "ABCD1", "VAMP1")
SurfaceProteins_df <- Gene2SProtein(GeneNames, input_type = "gene_name")
Splot(SurfaceProteins_df)}
}
\seealso{
Other plot functions: 
\code{\link{Enrichment_barplot}()},
\code{\link{SVenn}()},
\code{\link{plotPCA}()}
}
\concept{plot functions}
