% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotComplexRoc}
\alias{plotComplexRoc}
\title{Plot Complex ROC curve}
\usage{
plotComplexRoc(tpcaObj, computeAUC = FALSE)
}
\arguments{
\item{tpcaObj}{tpcaResult object}

\item{computeAUC}{logical parameter indicating
whether area under the ROC should be computed
and indicated in the lower right corner of the 
plot}
}
\value{
ggplot object of a receiver operating
curve (ROC)
}
\description{
Plots a ROC curve representing how well a given
TPP dataset recovers annotated proteins complexes.
The ROC curve is generated based on the supplied protein 
complex annotation specificity is assessed by comparing
the given complex annotation to random permutations of 
that table, i.e. proteins randomly grouped together.
}
\examples{
rocTab = data.frame(
    TPR = c(0, 0.1, 0.2, 0.4, 0.5, 0.7, 0.9, 1),
    FPR = c(0, 0.05, 0.1, 0.2, 0.5, 0.7, 0.9, 1)
)

tpcaTest <- new(
    "tpcaResult",
    ComplexRocTable = rocTab)

plotComplexRoc(tpcaTest)

}
