% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{createDistMat}
\alias{createDistMat}
\title{Create distance matrix of all vs all protein 
melting profiles}
\usage{
createDistMat(
  objList,
  rownameCol = NULL,
  summaryMethodStr = "median",
  distMethodStr = "euclidean"
)
}
\arguments{
\item{objList}{list of objects suitable for the analysis,
currently allowed classes of objects are: matrices,
data.frames, tibbles and ExpressionSets}

\item{rownameCol}{in case the input objects are tibbles
this parameter takes in the name (character) of the column 
specifying protein names or ids}

\item{summaryMethodStr}{character string indicating a method 
to use to summarize measurements across replicates, 
default is "median", other options are c("mean", "rbind")}

\item{distMethodStr}{method to use within dist function,
default is 'euclidean'}
}
\value{
a distance matrix of all pairwise protein
melting profiles
}
\description{
Create distance matrix of all vs all protein 
melting profiles
}
\examples{
library(Biobase)

m1 <- matrix(1:12, ncol = 4)
m2 <- matrix(2:13, ncol = 4)
m3 <- matrix(c(2:10, 1:7), ncol = 4)

rownames(m1) <- 1:3
rownames(m2) <- 2:4
rownames(m3) <- 2:5

colnames(m1) <- paste0("X", 1:4)
colnames(m2) <- paste0("X", 1:4)
colnames(m3) <- paste0("X", 1:4)

mat_list <- list(
    m1, m2, m3
)

createDistMat(mat_list)

expr1 <- ExpressionSet(m1)
expr2 <- ExpressionSet(m2)
expr3 <- ExpressionSet(m3)

exprSet_list <- list(
    expr1, expr2, expr3
)

createDistMat(exprSet_list)

}
