% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpikeOverview.R
\name{plot_identified_spiked_proteins}
\alias{plot_identified_spiked_proteins}
\title{Plot number of identified spike-in proteins per sample.}
\usage{
plot_identified_spiked_proteins(se, color_by = NULL, label_by = NULL)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{color_by}{String specifying the column to color the samples (If NULL, the condition column of the SummarizedExperiment object is used. If "No", no color bar added.)}

\item{label_by}{String specifying the column to label the samples (If NULL, the labels column of the SummarizedExperiment object is used. If "No", no labeling of samples done.)#'}
}
\value{
ggplot object
}
\description{
Plot number of identified spike-in proteins per sample.
}
\examples{
data(spike_in_se)
plot_identified_spiked_proteins(spike_in_se, color_by = NULL,
                                label_by = NULL)

}
