% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_plots.R
\name{pcaPlot}
\alias{pcaPlot}
\title{Simple PCA analysis from table}
\usage{
pcaPlot(
  table,
  path = NULL,
  group = sub("_r[0-9]+$", "", colnames(table)),
  replicate = sub(".*_r([0-9]+)$", "\\\\1", colnames(table)),
  PCA_X = "PC1",
  PCA_Y = "PC2",
  title = "PCA analysis by CDS fpkm",
  subtitle = paste("Numer of genes/regions:", nrow(table)),
  plot.ext = ".pdf",
  return.data = FALSE
)
}
\arguments{
\item{table}{data.table, e.g. countTable(df, "cds", type = "fpkm"),
a data.table of counts per column (default normalized fpkm values).}

\item{path}{default NULL, else character path to file to save.
File saved as "PCAplot_(experiment name)(plot.ext)"}

\item{group}{character vector of equal size to nrow of dt,
\code{default group = sub("_r[0-9]+$", "", colnames(table))}}

\item{replicate}{haracter vector of equal size to nrow of dt,
\code{sub(".*_r([0-9]+)$", "\\1", colnames(table))}}

\item{PCA_X}{name of priniciple component to use for x axis: valid options: PC1-PC6}

\item{PCA_Y}{name of priniciple component to use for y axis: valid options: PC1-PC6}

\item{title}{character, default "CDS fpkm".}

\item{subtitle}{character, default: \code{paste("Numer of genes:", nrow(table))}}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".}

\item{return.data}{logical, default FALSE. Return data instead of plot}
}
\value{
ggplot or invisible(NULL) if output.dir is defined or < 3 samples.
Returns data.table with PCA analysis if return.data is TRUE.
}
\description{
Detect outlier libraries with PCA analysis.
Will output PCA plot of PCA component 1 (x-axis) vs
PCA component 2 (y-axis) for each library (colored by library),
shape by replicate.
}
\examples{
df <- ORFik.template.experiment()
# Select only Ribo-seq and RNA-seq
df <- df[df$libtype \%in\% c("RNA", "RFP"),]
table <- countTable(df, "cds", type = "fpkm")
pcaPlot(table)

}
