% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txdbHelpers.R
\name{loadTranscriptType}
\alias{loadTranscriptType}
\title{Load transcripts of given biotype}
\usage{
loadTranscriptType(object, part = "rRNA", tx = NULL)
}
\arguments{
\item{object}{a TxDb, ORFik experiment or path to gtf/gff,}

\item{part}{a character, default rRNA. Can also be:
snoRNA, tRNA etc. As long as that biotype is defined in the gtf.}

\item{tx}{a GRangesList of transcripts (Optional, default NULL,
all transcript of that type), else it must be names a list to subset on.}
}
\value{
a GRangesList of transcript of that type
}
\description{
Like rRNA, snoRNA etc.
NOTE: Only works on gtf/gff, not .db object for now.
Also note that these anotations are not perfect, some rRNA annotations
only contain 5S rRNA etc. If your gtf does not contain evertyhing you need,
use a resource like repeatmasker and download a gtf:
https://genome.ucsc.edu/cgi-bin/hgTables
}
\examples{
gtf <- "path/to.gtf"
#loadTranscriptType(gtf, part = "rRNA")
#loadTranscriptType(gtf, part = "miRNA")
}
\references{
doi: 10.1002/0471250953.bi0410s25
}
