% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riboseq_features.R
\name{initiationScore}
\alias{initiationScore}
\title{Get initiation score for a GRangesList of ORFs}
\usage{
initiationScore(grl, cds, tx, reads, pShifted = TRUE, weight = "score")
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object with ORFs}

\item{cds}{a \code{\link{GRangesList}} object with coding sequences}

\item{tx}{a GRangesList of transcripts covering grl.}

\item{reads}{ribo seq reads as \code{\link{GAlignments}},
GRanges or GRangesList object}

\item{pShifted}{a logical (TRUE), are riboseq reads p-shifted?}

\item{weight}{a numeric/integer vector or metacolumn name.
(default: 1L, no differential weighting).
If weight is name of defined meta column in reads object,
it gives the number of times a read was found at that position.
GRanges("chr1", 1, "+", score = 5), would mean "score" column tells
that this alignment region was found 5 times.
if 1L it means each read is weighted equal as 1,
this is what among others countOverlaps() presumes,
if single number (!= 1), it repeats for all ranges,
if vector with length > 1, it must be equal size of the
reads object.}
}
\value{
an integer vector, 1 score per ORF, with names of grl
}
\description{
initiationScore tries to check how much each TIS region resembles, the
average of the CDS TIS regions.
}
\details{
Since this features uses a distance matrix for scoring, values are
distributed like this:\cr
As result there is one value per ORF:\cr
0.000: means that ORF had no reads\cr
-1.000: means that ORF is identical to average of CDS\cr
1.000: means that orf is maximum different than average of CDS\cr

If a score column is defined, it will use it as weights,
see \code{\link{getWeights}}
}
\examples{
# Good hiting ORF
ORF <- GRanges(seqnames = "1",
               ranges = IRanges(21, 40),
               strand = "+")
names(ORF) <- c("tx1")
grl <- GRangesList(tx1 = ORF)
# 1 width p-shifted reads
reads <- GRanges("1", IRanges(c(21, 23, 50, 50, 50, 53, 53, 56, 59),
                            width = 1), "+")
score(reads) <- 28 # original width
cds <- GRanges(seqnames = "1",
               ranges = IRanges(50, 80),
               strand = "+")
cds <- GRangesList(tx1 = cds)
tx <- GRanges(seqnames = "1",
               ranges = IRanges(1, 85),
               strand = "+")
tx <- GRangesList(tx1 = tx)

initiationScore(grl, cds, tx, reads, pShifted = TRUE)

}
\references{
doi: 10.1186/s12915-017-0416-0
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{distToTSS}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{insideOutsideORF}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
