% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imports.R
\name{fread.bed}
\alias{fread.bed}
\title{Load bed file as GRanges}
\usage{
fread.bed(filePath, chrStyle = NULL)
}
\arguments{
\item{filePath}{The location of the bed file}

\item{chrStyle}{a GRanges object, TxDb, FaFile,
, a \code{\link{seqlevelsStyle}} or \code{\link{Seqinfo}}.
(Default: NULL) to get seqlevelsStyle from. In addition if it
is a Seqinfo object, seqinfo will be updated.
Example of seqlevelsStyle update:
Is chromosome 1 called chr1 or 1,
 is mitocondrial chromosome called MT or chrM etc.
Will use 1st seqlevel-style if more are present.
Like: c("NCBI", "UCSC") -> pick "NCBI"}
}
\value{
a \code{\link{GRanges}} object
}
\description{
Wraps around \code{\link{import.bed}} and
tries to speed up loading with the
use of data.table. Supports gzip, gz, bgz and bed formats.
Also safer chromosome naming with the argument chrStyle
}
\examples{
# path to example CageSeq data from hg19 heart sample
cageData <- system.file("extdata", "cage-seq-heart.bed.bgz",
                        package = "ORFik")
fread.bed(cageData)

}
\seealso{
Other utils: 
\code{\link{bedToGR}()},
\code{\link{convertToOneBasedRanges}()},
\code{\link{export.bed12}()},
\code{\link{export.bigWig}()},
\code{\link{export.fstwig}()},
\code{\link{export.wiggle}()},
\code{\link{fimport}()},
\code{\link{findFa}()},
\code{\link{optimizeReads}()},
\code{\link{readBam}()},
\code{\link{readBigWig}()},
\code{\link{readWig}()}
}
\concept{utils}
