% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imports.R
\name{fimport}
\alias{fimport}
\title{Load any type of sequencing reads}
\usage{
fimport(
  path,
  chrStyle = NULL,
  param = NULL,
  strandMode = 0,
  only_unique_mappers = FALSE
)
}
\arguments{
\item{path}{a character path to file (1 or 2 files),
or data.table with 2 colums(forward&reverse)
or a GRanges/Galignment/GAlignmentPairs object etc.
If it is ranged object it will presume to be
already loaded, so will return the object as it is,
updating the seqlevelsStyle if given.}

\item{chrStyle}{a GRanges object, TxDb, FaFile,
, a \code{\link{seqlevelsStyle}} or \code{\link{Seqinfo}}.
(Default: NULL) to get seqlevelsStyle from. In addition if it
is a Seqinfo object, seqinfo will be updated.
Example of seqlevelsStyle update:
Is chromosome 1 called chr1 or 1,
 is mitocondrial chromosome called MT or chrM etc.
Will use 1st seqlevel-style if more are present.
Like: c("NCBI", "UCSC") -> pick "NCBI"}

\item{param}{\code{NULL} or a \link[Rsamtools]{ScanBamParam} object.
    Like for \code{\link[Rsamtools]{scanBam}}, this influences what fields
    and which records are imported. However, note that the fields specified
    thru this \link[Rsamtools]{ScanBamParam} object will be loaded
    \emph{in addition} to any field required for generating the returned
    object (\link[GenomicAlignments]{GAlignments}, \link[GenomicAlignments]{GAlignmentPairs},
    or \link[GenomicAlignments]{GappedReads} object),
    but only the fields requested by the user will actually be kept as
    metadata columns of the object.

    By default (i.e. \code{param=NULL} or \code{param=ScanBamParam()}), no 
    additional field is loaded. The flag used is 
    \code{scanBamFlag(isUnmappedQuery=FALSE)} for
    \code{readGAlignments}, \code{readGAlignmentsList}, and
    \code{readGappedReads}.
    (i.e. only records corresponding to mapped reads are loaded),
    and \code{scanBamFlag(isUnmappedQuery=FALSE, isPaired=TRUE,
    hasUnmappedMate=FALSE)} for \code{readGAlignmentPairs}
    (i.e. only records corresponding to paired-end reads with both ends
    mapped are loaded).
  }

\item{strandMode}{numeric, default 0. Only used for paired end bam files.
One of (0: strand = *, 1: first read of pair is +, 2: first read of pair is -).
See ?strandMode. Note: Sets default to 0 instead of 1, as readGAlignmentPairs uses 1.
This is to guarantee hits, but will also make mismatches of overlapping
transcripts in opposite directions.}

\item{only_unique_mappers}{logical, default FALSE. Only load unique mappers.
For bam files it extracts NH flag, for other formats, it presumes the presence of
a directory './unique_mappers' relative to bam file directory.}
}
\value{
a \code{\link{GAlignments}}/\code{\link{GRanges}} object,
 depending on input.
}
\description{
Wraps around ORFik file format loaders and rtracklayer::import
and tries to speed up loading with the
use of data.table. Supports gzip, gz, bgz compression formats.
Also safer chromosome naming with the argument chrStyle
}
\details{
NOTE: For wig/bigWig files you can send in 2 files, so that it automatically
merges forward and reverse stranded objects. You can also just send 1 wig/bigWig file,
it will then have "*" as strand.
}
\examples{
bam_file <- system.file("extdata/Danio_rerio_sample", "ribo-seq.bam", package = "ORFik")
fimport(bam_file)
# Certain chromosome naming
fimport(bam_file, "NCBI")
# Paired end bam strandMode 1:
fimport(bam_file, strandMode = 1)
# (will have no effect in this case, since it is not paired end)

}
\seealso{
Other utils: 
\code{\link{bedToGR}()},
\code{\link{convertToOneBasedRanges}()},
\code{\link{export.bed12}()},
\code{\link{export.bigWig}()},
\code{\link{export.fstwig}()},
\code{\link{export.wiggle}()},
\code{\link{findFa}()},
\code{\link{fread.bed}()},
\code{\link{optimizeReads}()},
\code{\link{readBam}()},
\code{\link{readBigWig}()},
\code{\link{readWig}()}
}
\concept{utils}
