% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarizedExperiment_helpers.R
\name{countTable}
\alias{countTable}
\title{Extract count table directly from experiment}
\usage{
countTable(
  df,
  region = "mrna",
  type = "count",
  collapse = FALSE,
  count.folder = "default",
  full_path = countTablePath(df, region, count.folder)
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}} or path to folder with
countTables, use path if not same folder as experiment libraries. Will subset to
the count tables specified if df is experiment. If experiment has 4 rows and you subset it
to only 2, then only those 2 count tables will be outputted.}

\item{region}{a character vector (default: "mrna"), make raw count matrices
of whole mrnas or one of (leaders, cds, trailers).}

\item{type}{character, default: "count" (raw counts matrix).
Which object type and normalization do you want ?
"summarized" (SummarizedExperiment object),
"deseq" (Deseq2 experiment, design will be all valid non-unique
columns except replicates, change by using DESeq2::design,
normalization alternatives are: "fpkm", "log2fpkm" or "log10fpkm".}

\item{collapse}{a logical/character (default FALSE), if TRUE all samples
within the group SAMPLE will be collapsed to one. If "all", all
groups will be merged into 1 column called merged_all. Collapse is defined
as rowSum(elements_per_group) / ncol(elements_per_group)}

\item{count.folder}{character, default "auto" (Use count tables from
original bam files stored in "QC_STATS", these are like HTseq count tables).
To load your custome count tables from pshifted reads, set to "pshifted"
(remember to create the pshifted tables first!). If you
have custom ranges, like reads over uORFs stored in a folder called
"/uORFs" relative to the bam files, set to "uORFs". Always create these
custom count tables with \code{\link{makeSummarizedExperimentFromBam}}.
Always make the location of the folder directly
inside the bam file directory!}

\item{full_path}{Full path to countTable, default: countTablePath(df, region, count.folder)}
}
\value{
a data.table/SummarizedExperiment/DESeq object
of columns as counts / normalized counts per library, column name
is name of library. Rownames must be unique for now. Might change.
}
\description{
Used to quickly load pre-created read count tables to R. \cr
If df is experiment:
Extracts by getting /QC_STATS directory, and searching for region
Requires \code{\link{ORFikQC}} to have been run on experiment,
to get default count tables!
}
\details{
If df is path to folder:
Loads the the file in that directory with the regex region.rds,
where region is what is defined by argument, if multiple exist,
see if any start with "countTable_", if so, subset. If loaded as SummarizedExperiment
or deseq, the colData will be made from ORFik.experiment information.
}
\examples{
# Make experiment
df <- ORFik.template.experiment()
# Make QC report to get counts ++ (not needed for this template)
# ORFikQC(df)

# Get count Table of mrnas
# countTable(df, "mrna")
# Get count Table of cds
# countTable(df, "cds")
# Get count Table of mrnas as fpkm values
# countTable(df, "mrna", type = "count")
# Get count Table of mrnas with collapsed replicates
# countTable(df, "mrna", collapse = TRUE)
# Get count Table of mrnas as summarizedExperiment
# countTable(df, "mrna", type = "summarized")
# Get count Table of mrnas as DESeq2 object,
# for differential expression analysis
# countTable(df, "mrna", type = "deseq")
}
\seealso{
Other countTable: 
\code{\link{countTable_regions}()}
}
\concept{countTable}
