% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dif_expression_helpers.R
\name{append_gene_symbols}
\alias{append_gene_symbols}
\title{Append gene symbols to a data.table with tx ids}
\usage{
append_gene_symbols(dt, symbols_dt, extend_id = TRUE, id_col = "id")
}
\arguments{
\item{dt}{a data.table, must have a id_col with transcript ids}

\item{symbols_dt}{the data.table with symbols, must have a column
with tx, transcript or value in the name. And only 1 of those!}

\item{extend_id}{logical, if TRUE, paste together old id from dt,
with the symbol id like: tx_id(symbol_id)}

\item{id_col}{character, default "id". The name of the id column in dt.}
}
\value{
a data.table
}
\description{
Main use case is to add gene symbols to data.table outputs from ORFik
with tx ids only, like the DTEG.analysis etc.
}
\examples{
library(data.table)
df <- ORFik.template.experiment()

cds_names <- names(loadRegion(df, "cds"))
dt <- data.table(id = cds_names[-1], LFC = seq(5), p.value = 0.05)

symbols_dt <- data.table(ensembl_tx_name = cds_names,
 ensembl_gene_id = txNamesToGeneNames(cds_names, df),
 external_gene_name = c("ATF4", "AAT1", "ML4", "AST2", "RPL4", "RPL12"))
append_gene_symbols(dt, symbols_dt)
append_gene_symbols(dt, symbols_dt, extend_id = FALSE)
}
