% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlite_database_class.R
\name{sqlite_database}
\alias{sqlite_database}
\title{SQLite database}
\usage{
sqlite_database(source, table = "annotation_database", ...)
}
\arguments{
\item{source}{(ANY) The source of annotation data.}

\item{table}{(character) The name of a table in the SQLite database.
The default is \code{"annotation_database"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
sqlite_database
} object. This object has no \code{output} slots.
}
\description{
A data.frame stored in an SQLite database.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{RSQLite}}}
}
\section{Inheritance}{

A \code{sqlite_database} object inherits the following \code{struct} classes:
\cr\cr
\verb{[sqlite_database]} -> \verb{[annotation_database]} ->
\verb{[annotation_source]} -> \verb{[struct_class]}
}

\examples{
M <- sqlite_database(
        table = character(0),
        tag = character(0),
        data = data.frame(),
        source = "ANY")

}
\references{
Müller K, Wickham H, James DA, Falcon S (2025). \emph{RSQLite:
SQLite Interface for R}. R package version 2.4.3,
\url{https://CRAN.R-project.org/package=RSQLite}.
}
\seealso{
Other database: 
\code{\link{BiocFileCache_database}}
}
\concept{database}
