% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mz_match_class.R
\name{mz_match}
\alias{mz_match}
\title{mz matching}
\usage{
mz_match(variable_meta, mz_column, ppm_window, id_column, ...)
}
\arguments{
\item{variable_meta}{(data.frame) A data.frame of variable IDs and
their corresponding mz values.}

\item{mz_column}{(character) Column name of the mz values in
variable_meta.}

\item{ppm_window}{(numeric, integer) Ppm window to use for matching.
If a single value is provided then the same ppm is used for both
variable meta and the annotations. A named vector can also be
provided e.g. c("variable_meta"=5,"annotations"=2) to use ",
"different windows for each data table.}

\item{id_column}{(character) Column name of the variable ids in
variable_meta. id_column="rownames" will use the rownames as ids.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{mz_match} object with the following \code{output}
slots:
\tabular{ll}{
\code{updated} \tab (annotation_source) The input annotation source
with the newly generated column. \cr
}
}
\description{
Annotations will be matched to the measured data
variable meta data.frame by determining which annotations ppm window
overlaps with the ppm window from the measured mz.
}
\section{Inheritance}{

A \code{mz_match} object inherits the following \code{struct} classes: \cr\cr
\verb{[mz_match]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- mz_match(
        variable_meta = data.frame(),
        mz_column = character(0),
        ppm_window = 5,
        id_column = character(0))

}
