% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_upset_chart_class.R
\name{annotation_upset_chart}
\alias{annotation_upset_chart}
\title{Annotation UpSet chart}
\usage{
annotation_upset_chart(
  factor_name,
  group_column = NULL,
  width_ratio = 0.2,
  xlabel = "group",
  sort_intersections = "descending",
  intersections = "observed",
  n_intersections = NULL,
  min_size = 0,
  queries = list(),
  keep_empty_groups = FALSE,
  ...
)
}
\arguments{
\item{factor_name}{(character) The name of the column(s) in the
\code{annotation_source}(s) to generate an UpSet chart from.}

\item{group_column}{(character, NULL) The name of the column in the
\code{annotation_source} to create groups from in the Venn diagram. This
parameter is ignored if there are multiple input tables, as each
table is considered to be a group. This parameter is also ignored if
more than one \code{factor_name} is provided, as each column is considered
a group. The default is \code{NULL}.}

\item{width_ratio}{(numeric) Proportion of plot given to set size bar
chart. The default is \code{0.2}.\cr}

\item{xlabel}{(character) The label used for the x-axis. The default
is \code{"group"}.}

\item{sort_intersections}{(character) Sort intersections. Allowed
values are limited to the following: \itemize{
\item{\code{"ascending"}: Groups are sorted by increasing
size.}\item{\code{"descending"}: Groups are sorted by decreasing
size.}\item{\code{"none"}: Groups are not sorted.}} The default is
\code{"descending"}.}

\item{intersections}{(character, list) The intersections to include
in the plot. The default is \code{"observed"}.}

\item{n_intersections}{(numeric, integer, NULL) The number of
intersections to include in the plot. The default is \code{NULL}.}

\item{min_size}{(numeric, integer) The minimum size of an
intersection for it to be included in the plot. The default is
\code{0}.\cr}

\item{queries}{(list) A list of upset queries. The default is
\code{list()}.}

\item{keep_empty_groups}{(logical) Whether empty sets should be kept
(including sets which are only empty after filtering by size). The
default is \code{FALSE}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
annotation_upset_chart
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to
plot this chart object.
}
\description{
Display an UpSet chart of labels in the specified column
of an annotation_source.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{ComplexUpset}}}
}
\section{Inheritance}{

A \code{annotation_upset_chart} object inherits the following \code{struct}
classes: \cr\cr
\verb{[annotation_upset_chart]} -> \verb{[chart]} -> \verb{[struct_class]}
}

\examples{
M <- annotation_upset_chart(
        factor_name = "V1",
        group_column = NULL,
        width_ratio = 0.2,
        xlabel = "group",
        sort_intersections = "descending",
        intersections = "observed",
        n_intersections = NULL,
        min_size = 0,
        queries = list(),
        keep_empty_groups = FALSE)

}
\references{
Krassowski M (2020). "ComplexUpset."
doi:10.5281/zenodo.3700590 \url{https://doi.org/10.5281/zenodo.3700590},
\url{https://doi.org/10.5281/zenodo.3700590}.

Lex A, Gehlenborg N, Strobelt H, Vuillemot R, Pfister H
(2014). "UpSet: Visualization of Intersecting Sets,." \emph{IEEE
Transactions on Visualization and Computer Graphics}, \emph{20}(12),
1983–1992. doi:10.1109/TVCG.2014.2346248
\url{https://doi.org/10.1109/TVCG.2014.2346248},
\url{https://doi.org/10.1109/TVCG.2014.2346248}.
}
