% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMahal.R
\name{plotMahal}
\alias{plotMahal}
\title{Biaxial plot}
\usage{
plotMahal(x, which, assay = "exprs", n = 1000)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{which}{character string. Specifies which barcode to plot.}

\item{assay}{character string specifying which assay to use.}

\item{n}{numeric. Number of cells to subsample; use NULL to include all.}
}
\value{
Plots all inter-barcode interactions for the population specified
by argument \code{which}. Events are colored by their Mahalanobis distance.
}
\description{
Histogram of counts and plot of yields as a function of separation cutoffs.
}
\examples{
data(sample_ff, sample_key)
sce <- prepData(sample_ff, by_time = FALSE)
sce <- assignPrelim(sce, sample_key)
sce <- estCutoffs(sce)
sce <- applyCutoffs(sce)
plotMahal(sce, which = "B3")

}
\references{
Zunder, E.R. et al. (2015).
Palladium-based mass tag cell barcoding with a doublet-filtering scheme 
and single-cell deconvolution algorithm.
\emph{Nature Protocols} \bold{10}, 316-333.
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
