% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcn_inference.R
\name{enrichment_analysis}
\alias{enrichment_analysis}
\title{Perform overrepresentation analysis for a set of genes}
\usage{
enrichment_analysis(
  genes,
  background_genes,
  annotation,
  column = NULL,
  correction = "BH",
  p = 0.05,
  min_setsize = 10,
  max_setsize = 500,
  bp_param = BiocParallel::SerialParam()
)
}
\arguments{
\item{genes}{Character vector containing genes for overrepresentation
analysis.}

\item{background_genes}{Character vector of genes to be used as background
for the overrepresentation analysis.}

\item{annotation}{Annotation data frame with genes in the first column and
functional annotation in the other columns. This data frame can be exported
from Biomart or similar databases.}

\item{column}{Column or columns of \strong{annotation} to be used for
enrichment.
Both character or numeric values with column indices can be used.
If users want to supply more than one column, input a character or
numeric vector. Default: all columns from \strong{annotation}.}

\item{correction}{Multiple testing correction method. One of "holm",
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr" or "none".
Default is "BH".}

\item{p}{P-value threshold. P-values below this threshold will be
considered significant. Default: 0.05.}

\item{min_setsize}{Numeric indicating the minimum gene set size to be
considered. Gene sets correspond to levels of each variable
in \strong{annotation}). Default: 10.}

\item{max_setsize}{Numeric indicating the maximum gene set size to be
considered. Gene sets correspond to levels of each variable
in \strong{annotation}). Default: 500.}

\item{bp_param}{BiocParallel back-end to be used.
Default: BiocParallel::SerialParam()}
}
\value{
A data frame of overrepresentation results with the following
variables:
\describe{
  \item{term}{character, functional term ID/name.}
  \item{genes}{numeric, intersection length between input genes and genes
               in a particular functional term.}
  \item{all}{numeric, number of all genes in a particular functional term.}
  \item{pval}{numeric, P-value for the hypergeometric test.}
  \item{padj}{numeric, P-value adjusted for multiple comparisons using
              the method specified in parameter \strong{adj}.}
  \item{category}{character, name of the grouping variable (i.e., column
                  name of \strong{annotation}).}
}
}
\description{
Perform overrepresentation analysis for a set of genes
}
\examples{
\donttest{
data(filt.se)
data(zma.interpro)
genes <- rownames(filt.se)[1:50]
background_genes <- rownames(filt.se)
annotation <- zma.interpro
# Using p = 1 to show all results
enrich <- enrichment_analysis(genes, background_genes, annotation, p = 1)
}
}
\author{
Fabricio Almeida-Silva
}
