% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cormat_to_edgelist}
\alias{cormat_to_edgelist}
\title{Transform a correlation matrix to an edge list}
\usage{
cormat_to_edgelist(matrix)
}
\arguments{
\item{matrix}{Symmetrical correlation matrix.}
}
\value{
A 2-column data frame containing node 1, node 2 and edge weight.
}
\description{
Transform a correlation matrix to an edge list
}
\examples{
data(filt.se)
cor_mat <- cor(t(SummarizedExperiment::assay(filt.se)))
edgelist <- cormat_to_edgelist(cor_mat)
}
