% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_matrix.R
\name{write_matrix}
\alias{write_matrix}
\title{Export motifs as raw matrices.}
\usage{
write_matrix(motifs, file, positions = "columns", rownames = FALSE, type,
  sep = "", headers = TRUE, overwrite = FALSE, append = FALSE,
  digits = 6)
}
\arguments{
\item{motifs}{See \code{\link[=convert_motifs]{convert_motifs()}} for acceptable formats.}

\item{file}{\code{character(1)} File name.}

\item{positions}{\code{character(1)} One of \code{c('columns', 'rows')}. Partial
matching allowed.}

\item{rownames}{\code{logical(1)} Include alphabet letters as rownames.}

\item{type}{\code{character(1)} One of \code{c('PCM', 'PPM', 'PWM', 'ICM')}. If missing
will use whatever type the motif is currently stored as.}

\item{sep}{\code{character(1)} Indicates how to separate individual motifs. Set as
\code{NULL} to have no seperating lines between motifs (the default is to
use a blank line).}

\item{headers}{\code{logical(1)}, \code{character(1)} Indicating if and how to write names.}

\item{overwrite}{\code{logical(1)} Overwrite existing file.}

\item{append}{\code{logical(1)} Add to an existing file.}

\item{digits}{\code{numeric(1)} Number of digits to use for motif positions.}
}
\value{
\code{NULL}, invisibly.
}
\description{
Write motifs as simple matrices with optional headers to file.
}
\examples{
motif <- create_motif()
write_matrix(motif, tempfile(), headers = ">")

}
\seealso{
\code{\link[=read_matrix]{read_matrix()}}

Other write_motifs: 
\code{\link{write_homer}()},
\code{\link{write_jaspar}()},
\code{\link{write_meme}()},
\code{\link{write_motifs}()},
\code{\link{write_transfac}()}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
\concept{write_motifs}
