% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsetVarByCol.R
\name{upsetVarByCol}
\alias{upsetVarByCol}
\title{Show Variants by Impacted Columns}
\usage{
upsetVarByCol(
  gr,
  var,
  alt_col = "ALT",
  mcol = "transcript_id",
  ...,
  intersection_args = list(),
  intersection_lab = "Intersection Size",
  set_geom = geom_bar(width = 0.6),
  set_expand = 0.2,
  set_counts = TRUE,
  hjust_counts = 1.1,
  set_lab = "Set Size",
  title
)
}
\arguments{
\item{gr}{GRanges object with ranges representing a key feature such as exons}

\item{var}{GRanges object with variants in a given column}

\item{alt_col}{Column within \code{var} containing the alternate allele}

\item{mcol}{The column within \code{gr} to summarise results by}

\item{...}{Passed to \link[ComplexUpset:upset]{ComplexUpset::upset}}

\item{intersection_args}{See \link[ComplexUpset:intersection_size]{ComplexUpset::intersection_size} for possible
values}

\item{intersection_lab}{Y-axis label for the intersection panel}

\item{set_geom}{Passed to \link[ComplexUpset:upset_set_size]{ComplexUpset::upset_set_size}}

\item{set_expand}{Expand the set-size axis by this amount}

\item{set_counts}{logical(1) Show counts on set sizes}

\item{hjust_counts}{Horizontal adjustment of counts, if being shown}

\item{set_lab}{X-axis label for the set-sizes panel}

\item{title}{Summary title to show above the intersection panel. Can be
hidden by setting to NULL}
}
\value{
An UpSet plot
}
\description{
Produce an UpSet plot showing unique values from a given column
}
\details{
Take a set of variants, classify them as SNV, Insertion and Deletion, then
using a GRanges object, produce an UpSet plot showing impacted values from
a given column
}
\examples{
library(rtracklayer)
library(VariantAnnotation)
gtf <- import.gff(
    system.file("extdata/gencode.v44.subset.gtf.gz", package = "transmogR"),
    feature.type = "exon"
)
vcf <- system.file("extdata/1000GP_subset.vcf.gz", package = "transmogR")
var <- rowRanges(readVcf(vcf, param = ScanVcfParam(fixed = "ALT")))
upsetVarByCol(gtf, var)



}
\seealso{
\link[ComplexUpset:upset]{ComplexUpset::upset}
}
