% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportSCEtoAnndata.R
\name{exportSCEtoAnnData}
\alias{exportSCEtoAnnData}
\title{Export a \link[SingleCellExperiment]{SingleCellExperiment} R object as
Python annData object}
\usage{
exportSCEtoAnnData(
  sce,
  useAssay = "counts",
  outputDir = "./",
  prefix = "sample",
  overwrite = TRUE,
  compression = c("gzip", "lzf", "None"),
  compressionOpts = NULL,
  forceDense = FALSE
)
}
\arguments{
\item{sce}{\link[SingleCellExperiment]{SingleCellExperiment} R object to be
exported.}

\item{useAssay}{Character. The name of assay of
interests that will be set as the primary matrix of the output AnnData.
Default \code{"counts"}.}

\item{outputDir}{Path to the directory where .h5ad outputs will be written. Default is the current working directory.}

\item{prefix}{Prefix to use for the name of the output file. Default \code{"sample"}.}

\item{overwrite}{Boolean. Default \code{TRUE}.}

\item{compression}{If output file compression is required, this variable accepts
'gzip', 'lzf' or "None" as inputs. Default \code{"gzip"}.}

\item{compressionOpts}{Integer. Sets the compression level}

\item{forceDense}{Default \code{False} Write sparse data as a dense matrix.
Refer \code{anndata.write_h5ad} documentation for details. Default \code{NULL}.}
}
\value{
Generates a Python anndata object containing data from \code{inSCE}.
}
\description{
Writes all assays, colData, rowData, reducedDims, and altExps objects in a
\link[SingleCellExperiment]{SingleCellExperiment} to a Python annData object in the .h5ad format
All parameters of Anndata.write_h5ad function (https://icb-anndata.readthedocs-hosted.com/en/stable/anndata.AnnData.write_h5ad.html)
are available as parameters to this export function and set to defaults. Defaults can be
overridden at function call.
}
\examples{
data(sce_chcl, package = "scds")
\dontrun{
exportSCEtoAnnData(sce=sce_chcl, compression="gzip")
}
}
