% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RHDF5Array.R
\docType{class}
\name{HSDSArray}
\alias{HSDSArray}
\alias{HSDSArray-class}
\title{A DelayedArray backend for accessing a remote HDF5 server.}
\usage{
HSDSArray(endpoint, svrtype, domain, dsetname)
}
\arguments{
\item{endpoint}{URL of remote server}

\item{svrtype}{type of server, must be either 'hsds' or 'h5serv'}

\item{domain}{HDF5 domain of H5 file on server}

\item{dsetname}{complete internal path to dataset in H5 file}
}
\value{
An initialized object of type HSDSArray
}
\description{
A DelayedArray backend for accessing a remote HDF5 server.

Construct an object of type HSDSArray directly from the data
members of its seed
}
\examples{
if (check_hsds()) {
 HSDSArray(URL_hsds(), 
    "hsds", "/shared/bioconductor/darmgcls.h5", "/assay001")
}
}
\seealso{
Other HSDSArray: 
\code{\link{HSDSMatrix}},
\code{\link{as}()}
}
\concept{HSDSArray}
